% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{rx5day}
\alias{rx5day}
\title{Calculate Rx5day Index}
\usage{
rx5day(ci, freq = c("monthly", "annual"), center_mean_on_last_day = FALSE)
}
\arguments{
\item{ci}{List. Climate input object created by \code{\link{climate_input}}.}

\item{freq}{Character. Frequency of calculation, either "monthly" or "annual".}

\item{center_mean_on_last_day}{Logical. Whether to center the mean on the last day (default is FALSE).}
}
\value{
Data frame with dates and calculated Rx5day values.
}
\description{
Calculates the maximum consecutive 5-day precipitation amount.
}
\examples{
\donttest{
# 1. Generate a daily date sequence from 1960-01-01 to 2020-12-31
dates <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-31"),
  by   = "day"
)

# 2. Create random weather data for each date
n <- length(dates)
tmax <- runif(n, min = 5, max = 40)
tmin <- runif(n, min = -10,  max = 5)
# Example: use a Poisson distribution to simulate precipitation
prec <- rpois(n, lambda = 2)
# Random wind speeds, e.g., 0 to 10 m/s
wind <- runif(n, min = 0, max = 10)

# 3. Construct the climate_input object
ci <- climate_input(
  tmax  = tmax,
  tmin  = tmin,
  prec  = prec,
  wind  = wind,
  dates = dates
)
# Then:
# 4. Calculate monthly Rx5day index
rx5day_values <- rx5day(ci, freq = "monthly")
}
}
