% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ising.R
\name{ising}
\alias{ising}
\title{High-Dimensional Ising Model Selection}
\usage{
ising(X, gamma = 0.5, min_sd = 0, nlambda = 50,
  lambda.min.ratio = 0.001, symmetrize = "mean")
}
\arguments{
\item{X}{The design matrix.}

\item{gamma}{(non-negative double) Parameter for the extended BIC (default 0.5). Higher gamma encourages sparsity. See references for more details.}

\item{min_sd}{(non-negative double) Columns of \code{X} with standard deviation less than this value will be excluded from the graph.}

\item{nlambda}{(positive integer) The number of parameters in the regularization path (default 50). A longer regularization path will likely yield more accurate results, but will take more time to run.}

\item{lambda.min.ratio}{(non-negative double) The ratio \code{min(lambda) / max(lambda)} (default \code{1e-3}).}

\item{symmetrize}{The method used to symmetrize the output adjacency matrix. Must be one of "min", "max", "mean" (default), or FALSE. "min" and "max" correspond to the Wainwright min/max, respectively
(see reference 1). "mean" corresponds to the coefficient-wise mean of the output adjacency matrix and its transpose. If FALSE, the output matrix is not symmetrized.}
}
\value{
A list containing the estimated adjacency matrix (\code{Theta}) and the optimal regularization parameter for each node (\code{lambda}), as selected by extended BIC.
}
\description{
Ising Model selection using L1-regularized logistic regression and extended BIC.
}
\examples{

\dontrun{
# simulate a dataset using IsingSampler
library(IsingSampler)
n = 1e3
p = 10
Theta <- matrix(sample(c(-0.5,0,0.5), replace = TRUE, size = p*p), nrow = p, ncol = p)
Theta <- Theta + t(Theta) # adjacency matrix must be symmetric
diag(Theta) <- 0
X <- unname(as.matrix(IsingSampler(n, graph = Theta, thresholds = 0, method = "direct") ))
m1 <- ising(X, symmetrize = "mean", gamma = 0.5, nlambda = 50)

# Visualize output using igraph
library(igraph)
ig <- graph_from_adjacency_matrix(m1$Theta, "undirected", weighted = TRUE, diag = FALSE)
plot.igraph(ig, vertex.color = "skyblue")
}
}
\references{
\enumerate{
  \item Ravikumar, P., Wainwright, M. J. and Lafferty, J. D. (2010). High-dimensional Ising model selection using L1-regularized logistic regression. https://arxiv.org/pdf/1010.0311v1
  \item Barber, R.F., Drton, M. (2015). High-dimensional Ising model selection with Bayesian information criteria. https://arxiv.org/pdf/1403.3374v2
}
}

