% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderPackedBar.R
\name{packed_bar_shiny}
\alias{packed_bar_shiny}
\alias{packedBarOutput}
\alias{renderPackedBar}
\title{Plot rPackedBar in 'shiny'}
\usage{
packedBarOutput(outputId, width = "100\%", height = "400px",
  inline = FALSE, clickedBarInputId = paste0(outputId, "_clicked"))

renderPackedBar(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{inline}{use an inline (span()) or block container (div()) for the output}

\item{clickedBarInputId}{The input id to assign the label of the clicked bar.
Defaults to \code{outputId_clicked} and can be referenced in the server as \code{input$outputId_clicked}.}

\item{expr}{An expression that generates an rPackedBar.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using 'rPackedBar' within 'shiny' applications and interactive Rmd documents.
}
