% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplots.R
\name{plotCrossValidation}
\alias{plotCrossValidation}
\title{plotCrossValidation}
\usage{
plotCrossValidation(cv_results)
}
\arguments{
\item{cv_results}{The List of results returned by the calculateCrossValidation function.}
}
\value{
None.
}
\description{
Plots data generated by the calculateCrossValidation function as a boxplot. 
Includes max and min as whiskers as well as the average (marked by a crossed circle), 
median (marked by a horizontal bold line) and the 1st and 3rd quartile of the values. 
Visualizes outliers in the data as red triangles.
}
\examples{
df <- data.frame(
Sol_1=c(7, 6, 5, 4, 3, 2, 1),
Sol_2=c(1, 2, 3, 4, 5, 7, 6),
Sol_3=c(1, 2, 3, 4, 7, 5, 6),
Ref=c(1, 2, 3, 4, 5, 6, 7))

cv_results <- rSRD::calculateCrossValidation(df, output_to_file = FALSE) 
rSRD::plotCrossValidation(cv_results)
}
\author{
Linus Olsson \email{linusmeol@gmail.com}, Alexander Pothmann
}
