% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_metrics.R
\name{tree_metrics}
\alias{tree_metrics}
\title{Tree Metrics}
\usage{
tree_metrics(cloud, region.diameter = NULL, relocateZ = TRUE)
}
\arguments{
\item{cloud}{A \code{data.table} of the target point with three columns of the *XYZ* coordinates.}

\item{region.diameter}{A \code{numeric} vector of length 2 indicating the lower and higher region to subset the point cloud and get the diameter. If \code{region.diameter = NULL}, it use \code{c(1.25, 1.35)}. \code{NULL} as default.}

\item{relocateZ}{Logical, if \code{TRUE} it relocates the *Z* coordinates to a minimum coordinate of zero based on the current \code{min(cloud[,3])}. Useful if the base value (*Z*) of a tree point cloud is not topography corrected.}
}
\value{
A \code{data.table} with the tree height, crown area, and diameter
}
\description{
Estimate the tree height, crown area, and the diameter at breast height of a tree point cloud
}
\details{
The tree height is estimated based on the maximum value of *Z*, the
crown area is calculated applying a convex hull on the point cloud, while the
DBH is calculated extracting the area of the convex hull on the subset of points
between \code{region.diameter}, and then estimating the diameter of a circle.
For another estimation of DBH try \code{\link{circleRANSAC}} or for irregular
trucks try \code{\link{trunk_volume}}.
}
\examples{
data("pc_tree")
tree_metrics(pc_tree)

}
\seealso{
\code{\link{circleRANSAC}}, \code{\link{trunk_volume}}
}
\author{
J. Antonio Guzman Q. and Ronny Hernandez
}
