% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lactin2_1995.R
\name{lactin2_1995}
\alias{lactin2_1995}
\title{Lactin2 model for fitting thermal performance curves}
\usage{
lactin2_1995(temp, a, b, tmax, delta_t)
}
\arguments{
\item{temp}{temperature in degrees centigrade}

\item{a}{constant that determines the steepness of the rising portion of the curve}

\item{b}{constant that determines the height of the overall curve}

\item{tmax}{the temperature at which the curve begins to decelerate beyond the optimum (ºC)}

\item{delta_t}{thermal safety margin (ºC)}
}
\value{
a numeric vector of rate values based on the temperatures and parameter values provided to the function
}
\description{
Lactin2 model for fitting thermal performance curves
}
\details{
Equation:
\deqn{rate= = exp^{a \cdot temp} - exp^{a \cdot t_{max} - \bigg(\frac{t_{max} - temp}{\delta _{t}}\bigg)} + b}{%
rate =  exp(a.temp) - exp(a.tmax - ((tmax - temp) / delta_t)) + b}

Start values in \code{get_start_vals} are derived from the data or sensible values from the literature.

Limits in \code{get_lower_lims} and \code{get_upper_lims} are derived from the data or based extreme values that are unlikely to occur in ecological settings.
}
\note{
Generally we found this model easy to fit.
}
\examples{
# load in ggplot
library(ggplot2)

# subset for the first TPC curve
data('chlorella_tpc')
d <- subset(chlorella_tpc, curve_id == 1)

# get start values and fit model
start_vals <- get_start_vals(d$temp, d$rate, model_name = 'lactin2_1995')
# fit model
mod <- nls.multstart::nls_multstart(rate~lactin2_1995(temp = temp, a, b, tmax, delta_t),
data = d,
iter = c(3,3,3,3),
start_lower = start_vals - 10,
start_upper = start_vals + 10,
lower = get_lower_lims(d$temp, d$rate, model_name = 'lactin2_1995'),
upper = get_upper_lims(d$temp, d$rate, model_name = 'lactin2_1995'),
supp_errors = 'Y',
convergence_count = FALSE)

# look at model fit
summary(mod)

# get predictions
preds <- data.frame(temp = seq(min(d$temp), max(d$temp), length.out = 100))
preds <- broom::augment(mod, newdata = preds)

# plot
ggplot(preds) +
geom_point(aes(temp, rate), d) +
geom_line(aes(temp, .fitted), col = 'blue') +
theme_bw()

}
\references{
Lactin, D.J., Holliday, N.J., Johnson, D.L. & Craigen, R. Improved rate models of temperature-dependent development by arthropods. Environmental Entomology 24, 69-75 (1995)
}
