% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardise_qsm.R
\name{standardise_qsm}
\alias{standardise_qsm}
\alias{standardize_qsm}
\title{Standardise QSM}
\usage{
standardise_qsm(cylinder)

standardize_qsm(cylinder)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}
}
\value{
Returns a data frame
}
\description{
All QSM variables are renamed and reordered a standardised
format across the supported QSM software for a consistent experience.
All internal rTwig functions use these standardised names for consistency.
}
\details{
Renames supported QSM software output columns to be consistent.
All names are lower case and underscore delimited. See the dictionary
vignette for a detailed description of column names. A consistent QSM format
ensures maximum compatibility when analyzing QSMs made with different
software. This function can be run either before or after
\code{update_cylinders()} has been run, or at any stage.

\code{standardise_qsm()} and \code{standardise_qsm()} are synonyms.
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_treeqsm(file)
cylinder <- qsm$cylinder
cylinder <- standardise_qsm(cylinder)
str(cylinder)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- standardise_qsm(cylinder)
str(cylinder)

## aRchi Processing Chain
file <- system.file("extdata/QSM2.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- standardise_qsm(cylinder)
str(cylinder)

}
