% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state-variables.R
\name{state-variables}
\alias{state-variables}
\alias{heads}
\alias{omega}
\alias{potential}
\alias{streamfunction}
\alias{omega.aem}
\alias{potential.aem}
\alias{streamfunction.aem}
\alias{omega.element}
\alias{potential.element}
\alias{streamfunction.element}
\title{Calculate state-variables}
\usage{
heads(aem, x, y, as.grid = FALSE, na.below = TRUE, ...)

omega(...)

potential(...)

streamfunction(...)

\method{omega}{aem}(aem, x, y, as.grid = FALSE, ...)

\method{potential}{aem}(aem, x, y, as.grid = FALSE, ...)

\method{streamfunction}{aem}(aem, x, y, as.grid = FALSE, ...)

\method{omega}{element}(element, x, y, ...)

\method{potential}{element}(element, x, y, ...)

\method{streamfunction}{element}(element, x, y, ...)
}
\arguments{
\item{aem}{\code{aem} object.}

\item{x}{numeric x coordinates to evaluate the variable at.}

\item{y}{numeric y coordinates to evaluate the variable at.}

\item{as.grid}{logical, should a matrix be returned? Defaults to \code{FALSE}. See details.}

\item{na.below}{logical indicating if calculated head values below the aquifer base should be set to \code{NA}. Defaults to \code{TRUE}. See \code{\link[=potential_to_head]{potential_to_head()}}.}

\item{...}{ignored}

\item{element}{analytic element of class \code{element}.}
}
\value{
For \code{\link[=heads]{heads()}}, a vector of \code{length(x)} (equal to \code{length(y)}) with the hydraulic head values at \code{x} and \code{y}.
If \code{as.grid = TRUE}, a matrix of dimensions \code{c(length(y), length(x))} described by
marginal vectors \code{x} and \code{y} containing the hydraulic head values at the grid points.
The heads are computed from \code{\link[=potential]{potential()}} and the aquifer parameters using \code{\link[=potential_to_head]{potential_to_head()}}.

For \code{\link[=omega]{omega()}}, the same as for \code{\link[=heads]{heads()}} but containing the complex potential values
evaluated at \code{x} and \code{y}.

For \code{\link[=potential]{potential()}}, the same as for \code{\link[=heads]{heads()}} but containing the discharge potential values
evaluated at \code{x} and \code{y}, which are the real components of \code{\link[=omega]{omega()}}.

For \code{\link[=streamfunction]{streamfunction()}}, the same as for \code{\link[=heads]{heads()}} but containing the stream function values
evaluated at \code{x} and \code{y}, which are the imaginary components of \code{\link[=omega]{omega()}}.
}
\description{
\code{\link[=heads]{heads()}} computes the hydraulic head at the given x and y coordinates for an \code{aem} object.

\code{\link[=omega]{omega()}} computes the complex potential for an \code{aem} or \code{element} object
at the given x and y coordinates.

\code{\link[=potential]{potential()}} computes the discharge potential for an \code{aem} or \code{element} object
at the given x and y coordinates.

\code{\link[=streamfunction]{streamfunction()}} computes the stream function for an \code{aem} or \code{element} object
at the given x and y coordinates.
}
\details{
\code{\link[=heads]{heads()}} should not to be confused with \code{\link[utils:head]{utils::head()}}, which returns the first part of an object.
}
\examples{
w <- well(xw = 55, yw = 0, Q = 200)
uf <- uniformflow(gradient = 0.002, angle = -45, TR = 100)
rf <- constant(xc = -1000, yc = 1000, hc = 10)
ml <- aem(k = 10, top = 10, base = -15, n = 0.2, w, uf, rf)

xg <- seq(-100, 100, length = 5)
yg <- seq(-75, 75, length = 3)

# Hydraulic heads
heads(ml, c(50, 0), c(25, -25))
heads(ml, xg, yg, as.grid = TRUE)

# do not confuse heads() with utils::head, which will give an error
try(
head(ml, c(50, 0), c(25, -25))
)

# Complex potential
omega(ml, c(50, 0), c(25, -25))

# Discharge potential
potential(ml, c(50, 0), c(25, -25))

# Stream function
streamfunction(ml, c(50, 0), c(25, -25))

# For elements
omega(w, c(50, 0), c(-25, 25))

potential(w, c(50, 0), c(-25, 25))

streamfunction(w, c(50, 0), c(-25, 25))

}
\seealso{
\code{\link[=flow]{flow()}}, \code{\link[=satthick]{satthick()}}, \code{\link[=head_to_potential]{head_to_potential()}}
}
