% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{ragnar_retrieve}
\alias{ragnar_retrieve}
\title{Retrieve chunks from a \code{RagnarStore}}
\usage{
ragnar_retrieve(store, text, top_k = 3L, ..., deoverlap = TRUE)
}
\arguments{
\item{store}{A \code{RagnarStore} object returned by \code{ragnar_store_connect()} or \code{ragnar_store_create()}.}

\item{text}{Character. Query string to match.}

\item{top_k}{Integer. Number of nearest entries to find per method.}

\item{...}{Additional arguments passed to the lower-level retrieval functions.}

\item{deoverlap}{Logical. If \code{TRUE} (default) and \code{store@version == 2},
overlapping chunks are merged with \code{\link[=chunks_deoverlap]{chunks_deoverlap()}}.}
}
\value{
A \code{tibble} of retrieved chunks. Each row
represents a chunk and always contains a \code{text} column.
}
\description{
Combines both \code{vss} and \code{bm25} search and returns the
union of chunks retrieved by both methods.
}
\note{
The results are not re-ranked after identifying the unique values.
}
\examples{
\dontshow{if ((rlang::is_installed("dbplyr") && nzchar(Sys.getenv("OPENAI_API_KEY")) && ragnar:::can_load_duckdb_extensions())) withAutoprint(\{ # examplesIf}
## Build a small store with categories
store <- ragnar_store_create(
  embed = \(x) ragnar::embed_openai(x, model = "text-embedding-3-small"),
  extra_cols = data.frame(category = character()),
  version = 1 # store text chunks directly
)

ragnar_store_insert(
  store,
  data.frame(
    category = c(rep("pets", 3), rep("dessert", 3)),
    text     = c("playful puppy", "sleepy kitten", "curious hamster",
                 "chocolate cake", "strawberry tart", "vanilla ice cream")
  )
)
ragnar_store_build_index(store)

# Top 3 chunks without filtering
ragnar_retrieve(store, "sweet")

# Combine filter with similarity search
ragnar_retrieve(store, "sweet", filter = category == "dessert")
\dontshow{\}) # examplesIf}
}
\seealso{
Other ragnar_retrieve: 
\code{\link{ragnar_retrieve_bm25}()},
\code{\link{ragnar_retrieve_vss}()},
\code{\link{ragnar_retrieve_vss_and_bm25}()}
}
\concept{ragnar_retrieve}
