% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{ragnar_store_atlas}
\alias{ragnar_store_atlas}
\title{Visualize a store using Embedding Atlas}
\usage{
ragnar_store_atlas(
  store,
  ...,
  host = "localhost",
  port = 3030,
  launch.browser = interactive()
)
}
\arguments{
\item{store}{A \code{RagnarStore} object to inspect.}

\item{...}{Passed to \code{\link[shiny:runApp]{shiny::runApp()}}.}

\item{host}{Host to run the Embedding Atlas server on.}

\item{port}{Port to run the Embedding Atlas server on.}

\item{launch.browser}{Whether to launch the browser automatically.}
}
\description{
Visualize a store using Embedding Atlas
}
\note{
This function requires the \code{embedding-atlas} Python package.
Make sure you have it installed in your reticulate Python environment.
It also uses \code{arrow} to transfer data from the DuckDB store to Python.
}
\examples{
\dontrun{
# Connect or create a store
store <- ragnar_store_connect(':memory:')
# Launch the Embedding Atlas app
ragnar_store_atlas(store)
}


}
