% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit.R
\name{take_implicit_timestep}
\alias{take_implicit_timestep}
\title{Backwardate grid values one timestep}
\usage{
take_implicit_timestep(
  t,
  S,
  full_discount_factor,
  local_discount_factor,
  discount_factor_fcn,
  prev_grid_values,
  survival_probabilities,
  tridiag_matrix_entries,
  instrument = NULL,
  dividends = NULL,
  instr_name = "this instrument"
)
}
\arguments{
\item{t}{Time after this timestep has been taken}

\item{S}{Underlying equity values for the grid}

\item{full_discount_factor}{A discount factor for the transform from
grid values to actual derivative prices}

\item{local_discount_factor}{A discount factor to apply to
recovery values}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{prev_grid_values}{A vector of space grid values from the
previously calculated timestep}

\item{survival_probabilities}{Vector of probabilities of survival
for each space grid node}

\item{tridiag_matrix_entries}{Diagonal, superdiagonal and subdiagonal
of tridiagonal matrix from the numerical integrator}

\item{instrument}{If not NULL/NA,  must have a \code{recovery_fcn} and
an \code{optionality_fcn} though those properties are
themselves allowed to be NA.}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}}

\item{instr_name}{Name of instrument to use in log messages}
}
\value{
Grid values for the instrument after taking the implicit timestep
}
\description{
Take one timestep of an implicit solver for a given instrument
}
\seealso{
Other Implicit Grid Solver: 
\code{\link{construct_implicit_grid_structure}()},
\code{\link{find_present_value}()},
\code{\link{form_present_value_grid}()},
\code{\link{infer_conforming_time_grid}()},
\code{\link{integrate_pde}()},
\code{\link{iterate_grid_from_timestep}()},
\code{\link{timestep_instruments}()}
}
\concept{Implicit Grid Solver}
