% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processResults.R
\name{ProcessRAI}
\alias{ProcessRAI}
\alias{plot_ntest_rS}
\alias{plot_ntest_wealth}
\alias{predict.rai}
\alias{summary.rai}
\title{Summarising RAI Output}
\usage{
plot_ntest_rS(rawSum)

plot_ntest_wealth(rawSum)

\method{predict}{rai}(object, newdata = NULL, alpha = NULL,
  omega = NULL, ...)

\method{summary}{rai}(object, ...)
}
\arguments{
\item{rawSum}{processed version of rai summary stored as a tibble with
correct column parsing.}

\item{object}{an object of class rai; expected to be the list output from the
\code{\link{rai}} function.}

\item{newdata}{an optional data frame in which to look for variables with
which to predict. If omitted, the fitted values are used.}

\item{alpha}{level of procedure.}

\item{omega}{return from rejecting a test in Alpha-Investing (<= alpha).}

\item{...}{additional arguments affecting the summary or predict methods.}
}
\value{
A list which includes the following components: \item{plot_rS}{plot
  of the change in r.squared over time (number of tests conducted).}
  \item{plot_wealth}{plot of the change in r.squared over time (number of
  tests conducted).} \item{experts}{summary of expert performance: number of
  features, number of rejections, order in which they were added to the expert
  list.} \item{tests}{table of number of times features were tested: how many
  features tested k times; which expert(s) conducted tests.} \item{epochs}{in
  which epochs were tests rejected and the corresponding rejection
  thresholds.} \item{stats}{summary statistics: number of tests, number of
  epochs, bound on percentage reduction in ESS by adding a single feature,
  number of passes through to features, final r.squared, cost of raiPlus (0
  for rai).}\item{options}{options given to RAI: algorithm, searchType, poly,
  startDegree, r.}
}
\description{
Processes the output from the \code{\link{rai}} function.
  Requires dplyr, tibble, and ggplot2 packages.
}
\examples{
  data("CO2")
  theResponse = CO2$uptake
  theData = CO2[ ,-5]
  rai_out = rai(theData, theResponse)
  summary(rai_out)  # summary information including graphs
  predict(rai_out)  # fitted values from selected model
}
