% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_offdefnt.R
\name{offdefnt}
\alias{offdefnt}
\title{Kleinberg's HITS algorithm for Rating and Ranking with Rectangular Matrix}
\usage{
offdefnt(
  jpMat,
  method = "hitsjp",
  totalsupporteps = 0,
  numiter = 100,
  ties.method = "average"
)
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{method}{a character string specifying the HITS algorithm, including "hitsjp".}

\item{totalsupporteps}{a small number to guarantee the total support property}

\item{numiter}{a number of iterations}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Kleinberg's HITS algorithm, using a rectangular matrix for score matrix (judege-presenter)
}
\details{
movie i is good and deserves a high rating mi if it gets high ratings from good (discriminating ) users. Similarly, user j is good and serves a high rating hj when his or her ratings match the true ratings of the movies.
\enumerate{
\item \code{hitsjp}: HITS, using judge-presenter matrix, equivalent to \code{offdefsc}
\item \code{offdefnt}: Offense-Defense rating method, using judge-presenter matrix
}
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),nrow=6,byrow=TRUE)
method <- 'hitsjp'
totalsupporteps <- 0.01
numiter <- 10
ties.method <-'average'
result <- offdefnt(jpMat, method, totalsupporteps, numiter, ties.method)
print(result)
}
\references{
Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.

Kleinberg, J. M. (1999). Authoritative sources in a hyperlinked environment. Journal of the ACM 46, 604-632.

Langville, A. N. and Meyer, C. D. (2012). Who's Number 1?: The Science of Rating and Ranking. Princeton University Press.
}
\author{
Jiangtao Gou
}
