% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lon_lat_fine.R
\name{lon_lat_fine}
\alias{lon_lat_fine}
\title{Linear interpolation of longitude and latitude vectors to higher resolution}
\usage{
lon_lat_fine(lon, lat, nf)
}
\arguments{
\item{lon}{vector of longitudes.}

\item{lat}{vector of latitudes.}

\item{nf}{factor by which to increase resolution.}
}
\value{
List with elements \code{lon} and \code{lat} with resolution increased by
factor \code{nf}.
}
\description{
Longitude and latitude vectors are interpolated higher
resolution increasing dimensions by a factor \code{nf}. The grid spacings
of the first two and of the last two elements are used to
extrapolate at the boundaries.
}
\examples{
lon <- 5:9
lat <- 43:47
nf <- 4
grid <- lon_lat_fine(lon, lat, nf)
grid$lon
# [1] 4.625 4.875 5.125 5.375 5.625 5.875 6.125 6.375 6.625 6.875 7.125 7.375
# [13] 7.625 7.875 8.125 8.375 8.625 8.875 9.125 9.375
grid$lat
# [1] 42.625 42.875 43.125 43.375 43.625 43.875 44.125 44.375 44.625 44.875
# [11] 45.125 45.375 45.625 45.875 46.125 46.375 46.625 46.875 47.125 47.375
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
