% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergespec.R
\name{mergespec}
\alias{mergespec}
\title{Spectral merging of a coarse field and of a fine field at a given wavenumber}
\usage{
mergespec(ra, r, kmax = 0)
}
\arguments{
\item{ra}{matrix containing a coarse field of size \code{c(nas, nas)}.}

\item{r}{matrix containing a field at higher resolution.}

\item{kmax}{wavenumber to use for merging (default \code{nas/2}).}
}
\value{
The merged field, in physical space.
}
\description{
The input fields are transformed to Fourier space,
their Fourier spectra are merged at wavenumber \code{kmax} after adapting the
variance of the fine field and an inverse Fourier transform is performed.
}
\examples{
# Make a coarse field with power-law Fourier spectrum 
fa <- initmetagauss(1.7, 8)
ra <- metagauss(fa)
# Make a fine power-law Fourier spectrum
f <- initmetagauss(1.7, 32)
r <- metagauss(f)
# Merge the two fields in spectral space
rm <- mergespec(ra, r, kmax = 4)
# Check spectral slope of the resulting field
fx <- fft2d(rm)
fitslope(fx)
# 1.678554
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
