% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagauss.R
\name{metagauss}
\alias{metagauss}
\title{Generate a metagaussian field}
\usage{
metagauss(f)
}
\arguments{
\item{f}{matrix with complex spectral amplitudes generated with the
\code{\link[=initmetagauss]{initmetagauss()}} function.}
}
\value{
A metagaussian field with random Fourier phases.
}
\description{
Random Fourier phases are added to the input spectrum \code{f} and
an inverse FFT transform to real space is performed.
}
\examples{
f = initmetagauss(1.7, 64)
z = metagauss(f)
sd(z)
# [1] 1.000122
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
