% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{td_priceQuote}
\alias{td_priceQuote}
\title{Get Quotes for specified tickers in List form}
\usage{
td_priceQuote(tickers = c("AAPL", "MSFT"), output = "df", accessToken = NULL)
}
\arguments{
\item{tickers}{One or more tickers}

\item{output}{indication on whether the data should be returned as a list or
df. The default is 'df' for data frame, anything else would be a list.}

\item{accessToken}{A valid Access Token must be set using
\code{\link{td_auth_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
a list or data frame with quote details for each valid ticker
  submitted
}
\description{
Enter tickers for real time or delayed quotes returned as a list
}
\details{
Quotes may be delayed depending on agreement with TD Ameritrade. If the
account is set up for real-time quotes then this will return real-time.
Otherwise the quotes will be delayed.
}
\examples{
\dontrun{

# Get stored refresh token
refreshToken = readRDS('/secure/location/')

# generate a new access token
accessToken = td_auth_accessToken('consumerKey', refreshToken)

# Pass one or more tickers as a vector
# accessToken is optional once it is set
quoteSPY = td_priceQuote('SPY')
quoteList = td_priceQuote(c('GOOG','TSLA'), output = 'list', accessToken)

}
}
