% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_image_overlay.R
\name{render_image_overlay}
\alias{render_image_overlay}
\title{Add Overlay}
\usage{
render_image_overlay(
  image,
  image_overlay = NULL,
  rescale_original = FALSE,
  alpha = NULL,
  filename = NULL,
  preview = FALSE
)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array.}

\item{image_overlay}{Default \code{NULL}. Either a string indicating the location of a png image to overlay
over the image (transparency included), or a 4-layer RGBA array. This image will be resized to the
dimension of the image if it does not match exactly.}

\item{rescale_original}{Default \code{FALSE}. If \code{TRUE}, function will resize the original image to match
the overlay.}

\item{alpha}{Default \code{NULL}, using overlay's alpha channel. Otherwise, this sets the alpha transparency
by multiplying the existing alpha channel by this value (between 0 and 1).}

\item{filename}{Default \code{NULL}. File to save the image to. If \code{NULL} and \code{preview = FALSE},
returns an RGB array.}

\item{preview}{Default \code{FALSE}. If \code{TRUE}, it will display the image in addition
to returning it.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an RGB array/filename and adds an image overlay.
}
\examples{
if(run_documentation()){
#Plot the dragon
plot_image(dragon)
}
if(run_documentation()){
#Add an overlay of a red semi-transparent circle:
circlemat = generate_2d_disk(min(dim(dragon)[1:2]))
circlemat = circlemat/max(circlemat)

#Create RGBA image, with a transparency of 0.5
rgba_array = array(1, dim=c(nrow(circlemat),ncol(circlemat),4))
rgba_array[,,1] = circlemat
rgba_array[,,2] = 0
rgba_array[,,3] = 0
dragon_clipped = dragon
dragon_clipped[dragon_clipped > 1] = 1
render_image_overlay(dragon_clipped, image_overlay = rgba_array,
                 alpha=0.5, preview = TRUE)
}
}
