% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blimp_obj.R
\name{write.blimp}
\alias{write.blimp}
\alias{write.blimp,blimp_syntax-method}
\alias{write.blimp,blimp_out-method}
\alias{write.blimp,blimp_obj-method}
\title{A function to write out blimp input and output from a model}
\usage{
write.blimp(object, folder = "")

\S4method{write.blimp}{blimp_syntax}(object, folder = "")

\S4method{write.blimp}{blimp_out}(object, folder = "")

\S4method{write.blimp}{blimp_obj}(object, folder = "")
}
\arguments{
\item{object}{A \code{\link{blimp_obj}}.}

\item{folder}{a location to a folder to write input and output}
}
\value{
No return value, called for its side effect of writing 'Blimp'
input and output files to disk.
}
\description{
A function to write out blimp input and output from a model
}
\section{Methods (by class)}{
\itemize{
\item \code{write.blimp(blimp_syntax)}: Write blimp_syntax to file

\item \code{write.blimp(blimp_out)}: Write blimp_out to file

\item \code{write.blimp(blimp_obj)}: Write blimp_obj files to folder

}}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Generate Data with `rblimp_sim`
mydata <- rblimp_sim(
    c(
        'f ~ normal(0, 1)',
        'x1:x5 ~ normal(f, 1)',
        'y ~ normal(10 + 0.3*f, 1 - .3^2)'
     ),
     n = 500,
     seed = 19723,
     variables = c('y', 'x1:x5')
)

# Fit SEM Model
model <- rblimp(
    list(
        structure = 'y ~ f',
        measurement = 'f -> x1:x5'
    ),
    mydata,
    seed = 3927,
    latent = ~ f
)

# Write out input and output
\dontrun{
write.blimp(model, "folder_location")
}
\dontshow{\}) # examplesIf}
}
