% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie_image.R
\name{cie_image}
\alias{cie_image}
\title{CIE sky image}
\usage{
cie_image(z, a, sun_angles, sky_coef)
}
\arguments{
\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{sun_angles}{named numeric vector of length two, with components
\code{z} and \code{a} in degrees, e.g., \code{c(z = 49.3, a = 123.1)}.
See \code{\link[=estimate_sun_angles]{estimate_sun_angles()}} for details.}

\item{sky_coef}{numeric vector of length five. Parameters of the CIE sky model.}
}
\value{
\link[terra:SpatRaster-class]{terra::SpatRaster} with one layer whose pixel values
represent relative luminance or radiance across the sky hemisphere,
depending on whether the data used to obtain \code{sky_coef} was luminance
or radiance.
}
\description{
Generate an image of relative radiance or luminance based on the CIE
General Sky model.
}
\note{
Coefficient sets and formulation are available in \link{cie_table}.
}
\examples{
z <- zenith_image(50, lens())
a <- azimuth_image(z)
sky_coef <- cie_table[4,1:5] \%>\% as.numeric()
sun_angles <- c(z = 45, a = 0)
plot(cie_image(z, a, sun_angles, sky_coef))
}
