% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thr_isodata.R
\name{thr_isodata}
\alias{thr_isodata}
\title{Compute IsoData threshold}
\usage{
thr_isodata(x)
}
\arguments{
\item{x}{numeric vector or a single-column \code{matrix} or \code{data.frame} able to
be coerced to numeric.}
}
\value{
Numeric vector of length one.
}
\description{
Compute a threshold using the IsoData algorithm
\insertCite{isodata;textual}{rcaiman}, recommended by
\insertCite{Jonckheere2005;textual}{rcaiman}.
}
\details{
Implementation follows the IsoData method by Gabriel Landini, as implemented
in \code{\link[autothresholdr:auto_thresh]{autothresholdr::auto_thresh()}}. Unlike that version, this function
accepts numeric data over an arbitrary range. \code{NA} values are ignored.
}
\examples{
caim <- read_caim()
thr_isodata(caim$Blue[])
}
\references{
\insertAllCited{}
}
