% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_cie_model.R
\name{validate_cie_model}
\alias{validate_cie_model}
\title{Validate CIE sky models}
\usage{
validate_cie_model(model, k = 10)
}
\arguments{
\item{model}{list. Output of \code{\link[=fit_cie_model]{fit_cie_model()}}.}

\item{k}{numeric vector of length one. Number of folds.}
}
\value{
A list with:
\describe{
\item{lm}{An object of class \code{lm} (see \code{\link[stats:lm]{stats::lm()}}) for predicted vs. observed.}
\item{pred}{Numeric vector of predicted relative radiance used in \code{lm}.}
\item{obs}{Numeric vector of observed relative radiance used in \code{lm}.}
\item{r_squared}{Coefficient of determination (\eqn{R^2}).}
\item{rmse}{Root mean squared error (RMSE).}
\item{mae}{Median absolute error (MAE).}
\item{is_outlier}{Logical vector marking outliers (MAD > 3) in the original sky-point set.}
\item{metric}{Numeric value. Mean squared deviation as in \insertCite{Gauch2003;textual}{rcaiman}.}
}
}
\description{
Validate CIE sky models fitted with \code{\link[=fit_cie_model]{fit_cie_model()}} (or \code{\link[=ootb_sky_cie]{ootb_sky_cie()}})
using k-fold cross-validation on relative radiance.
}
\details{
Validation uses k-fold cross-validation with \code{k = 10} by default
\insertCite{Kohavi1995}{rcaiman}. For each fold, predictions are
compared against observed relative radiance and a simple linear regression
of predicted vs. observed is fitted, following
\insertCite{Pineiro2008;textual}{rcaiman}. Outliers are detected with a
median–MAD rule (see \code{\link[=rem_outliers]{rem_outliers()}}) using a threshold of 3
and removed before fitting the regression.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
path <- system.file("external/sky_points.csv", package = "rcaiman")
sky_points <- read.csv(path)[c("Y", "X")]
names(sky_points) <- c("row", "col")
rr <- extract_rr(caim$Blue, z, a, sky_points)

set.seed(7)
model <- fit_cie_model(rr, sun_angles = c(z = 49.5, a = 27.4),
                       general_sky_type = "Clear", method = "CG")
val <- validate_cie_model(model, k = 10)
val$r_squared
val$rmse
}
}
\references{
\insertAllCited{}
}
