/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.RealRange;

public class RealRangeList {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(RealRangeList.class);
    private List<RealRange> rangeList = new ArrayList<RealRange>();
    private int pointer;
    private boolean merged;
    private RealRange newRange;
    private RealRange oldRange;

    public int addRange(RealRange range) {
        int result = -1;
        if (this.rangeList.size() == 0) {
            this.rangeList.add(range);
            result = 0;
        } else {
            this.newRange = range;
            result = this.insertRange1();
        }
        return result;
    }

    private int insertRange1() {
        int firstHigher = this.pointer = this.findFirstLargerOrOverlappingExistingRange();
        List<Integer> overlappingRanges = this.findAllOverlappingRanges();
        this.subsumeAndDeleteAllOverlappingRanges(overlappingRanges);
        this.rangeList.add(firstHigher, this.newRange);
        return firstHigher;
    }

    private int findFirstLargerOrOverlappingExistingRange() {
        this.pointer = 0;
        while (this.pointer < this.rangeList.size()) {
            this.oldRange = this.rangeList.get(this.pointer);
            if (this.oldRange.getMax() >= this.newRange.getMin()) break;
            ++this.pointer;
        }
        return this.pointer;
    }

    private List<Integer> findAllOverlappingRanges() {
        ArrayList<Integer> overlappingRanges = new ArrayList<Integer>();
        while (this.pointer < this.rangeList.size()) {
            this.oldRange = this.rangeList.get(this.pointer);
            if (this.oldRange.getMin() > this.newRange.getMax()) break;
            this.newRange.plusEquals(this.oldRange);
            overlappingRanges.add(this.pointer);
            ++this.pointer;
        }
        return overlappingRanges;
    }

    private void subsumeAndDeleteAllOverlappingRanges(List<Integer> overlappingRanges) {
        Collections.reverse(overlappingRanges);
        int noverlap = overlappingRanges.size();
        for (int i = 0; i < noverlap; ++i) {
            int toRemove = overlappingRanges.get(i);
            this.rangeList.remove(toRemove);
        }
    }

    public int size() {
        return this.rangeList.size();
    }

    public RealRange get(int i) {
        return i < 0 || i >= this.rangeList.size() ? null : this.rangeList.get(i);
    }

    public RealRange remove(int i) {
        return i < 0 || i >= this.rangeList.size() ? null : this.rangeList.remove(i);
    }

    public String toString() {
        return this.rangeList.toString();
    }
}

