/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.testutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.tests.XOMTestCase;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.IntMatrix;
import org.xmlcml.euclid.IntSet;
import org.xmlcml.euclid.JodaDate;
import org.xmlcml.euclid.Line3;
import org.xmlcml.euclid.Plane3;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Point3Vector;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Vector;
import org.xmlcml.euclid.Real3Range;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealMatrix;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.RealSquareMatrix;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Transform3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector2;
import org.xmlcml.euclid.Vector3;
import org.xmlcml.stml.STMLConstants;
import org.xmlcml.stml.STMLElement;
import org.xmlcml.xml.XMLUtil;

public final class TestUtils
implements STMLConstants {
    private static final Logger logger = Logger.getLogger(TestUtils.class);
    public static final String OUTPUT_DIR_NAME = "target/test-outputs";

    public static void assertEqualsCanonically(String message, Node refNode, Node testNode) {
        try {
            XOMTestCase.assertEquals((String)message, (Node)refNode, (Node)testNode);
        }
        catch (ComparisonFailure e) {
            TestUtils.reportXMLDiff(message, e.getMessage(), refNode, testNode);
        }
        catch (AssertionFailedError e) {
            TestUtils.reportXMLDiff(message, e.getMessage(), refNode, testNode);
        }
    }

    public static void assertEqualsIncludingFloat(String message, Node refNode, Node testNode, boolean stripWhite, double eps) {
        if (stripWhite && refNode instanceof Element && testNode instanceof Element) {
            refNode = TestUtils.stripWhite((Element)refNode);
            testNode = TestUtils.stripWhite((Element)testNode);
        }
        try {
            TestUtils.assertEqualsIncludingFloat(message, refNode, testNode, eps);
        }
        catch (AssertionError e) {
            logger.warn((Object)e);
            TestUtils.reportXMLDiffInFull(message, ((Throwable)((Object)e)).getMessage(), refNode, testNode);
        }
    }

    public static void assertEqualsIncludingFloat(String message, String expectedS, Node testNode, boolean stripWhite, double eps) {
        TestUtils.assertEqualsIncludingFloat(message, (Node)TestUtils.parseValidString(expectedS), testNode, stripWhite, eps);
    }

    private static void assertEqualsIncludingFloat(String message, Node refNode, Node testNode, double eps) {
        try {
            Assert.assertEquals((String)(message + ": classes"), testNode.getClass(), refNode.getClass());
            if (refNode instanceof Text) {
                TestUtils.testStringDoubleEquality(message + " on node: " + TestUtils.path(testNode), refNode.getValue().trim(), testNode.getValue().trim(), eps);
            } else if (refNode instanceof Comment) {
                Assert.assertEquals((String)(message + " comment"), (Object)refNode.getValue(), (Object)testNode.getValue());
            } else if (refNode instanceof ProcessingInstruction) {
                Assert.assertEquals((String)(message + " pi"), (Object)((ProcessingInstruction)refNode), (Object)((ProcessingInstruction)testNode));
            } else if (refNode instanceof Element) {
                int refNodeChildCount = refNode.getChildCount();
                int testNodeChildCount = testNode.getChildCount();
                String path = TestUtils.path(testNode);
                if (refNodeChildCount != testNodeChildCount) {
                    Assert.fail((String)("number of children of " + path + " " + refNodeChildCount + " != " + testNodeChildCount));
                }
                for (int i = 0; i < refNodeChildCount; ++i) {
                    TestUtils.assertEqualsIncludingFloat(message, refNode.getChild(i), testNode.getChild(i), eps);
                }
                Element refElem = (Element)refNode;
                Element testElem = (Element)testNode;
                Assert.assertEquals((String)(message + " name"), (Object)refElem.getLocalName(), (Object)testElem.getLocalName());
                Assert.assertEquals((String)(message + " namespace"), (Object)refElem.getNamespaceURI(), (Object)testElem.getNamespaceURI());
                Assert.assertEquals((String)(message + " attributes on " + refElem.getClass()), (long)refElem.getAttributeCount(), (long)testElem.getAttributeCount());
                for (int i = 0; i < refElem.getAttributeCount(); ++i) {
                    String attNamespace;
                    Attribute refAtt = refElem.getAttribute(i);
                    String attName = refAtt.getLocalName();
                    Attribute testAtt = testElem.getAttribute(attName, attNamespace = refAtt.getNamespaceURI());
                    if (testAtt == null) {
                        Assert.fail((String)(message + " attribute on ref not on test: " + attName));
                    }
                    TestUtils.testStringDoubleEquality(message + " attribute " + TestUtils.path((Node)testAtt) + " values differ:", refAtt.getValue(), testAtt.getValue(), eps);
                }
            } else {
                Assert.fail((String)(message + "cannot deal with XMLNode: " + refNode.getClass()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String path(Node testNode) {
        List<String> fullpath = TestUtils.path(testNode, new ArrayList<String>());
        Collections.reverse(fullpath);
        StringBuilder sb = new StringBuilder();
        for (String p : fullpath) {
            sb.append(p);
        }
        return sb.toString();
    }

    private static List<String> path(Node testNode, List<String> path) {
        if (testNode instanceof Element) {
            Element e = (Element)testNode;
            StringBuilder frag = new StringBuilder("/");
            if (!"".equals(e.getNamespacePrefix())) {
                frag.append(e.getNamespacePrefix()).append(":");
            }
            path.add(frag.append(e.getLocalName()).append("[").append(TestUtils.siblingOrdinal(e)).append("]").toString());
        } else if (testNode instanceof Attribute) {
            Attribute a = (Attribute)testNode;
            path.add("@" + a.getNamespacePrefix() + ":" + a.getLocalName());
        } else if (testNode instanceof Text) {
            path.add("/text()");
        }
        return testNode.getParent() != null ? TestUtils.path((Node)testNode.getParent(), path) : path;
    }

    private static int siblingOrdinal(Element e) {
        Element parent = (Element)e.getParent();
        if (parent == null) {
            return 0;
        }
        Elements els = parent.getChildElements(e.getLocalName(), e.getNamespaceURI());
        for (int i = 0; i < els.size(); ++i) {
            if (!els.get(i).equals((Object)e)) continue;
            return i;
        }
        throw new RuntimeException("Element was not a child of its parent. Most perplexing!");
    }

    private static void testStringDoubleEquality(String message, String refValue, String testValue, double eps) {
        testValue = testValue.trim();
        refValue = refValue.trim();
        if (testValue.endsWith(" ") || refValue.endsWith(" ")) {
            throw new RuntimeException("trim error");
        }
        if (!testValue.equals(refValue)) {
            boolean fail = true;
            try {
                TestUtils.compareAsFloats(message, refValue, testValue, eps);
                fail = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fail) {
                try {
                    TestUtils.compareAsFloatArrays(message, refValue, testValue, eps);
                    fail = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fail) {
                try {
                    TestUtils.compareAsDates(message, refValue, testValue, eps);
                    fail = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fail) {
                Assert.fail((String)("Cannot equate: " + refValue + " != " + testValue));
            }
        } else {
            Assert.assertEquals((String)message, (Object)refValue, (Object)testValue);
        }
    }

    private static void compareAsFloats(String message, String refValue, String testValue, double eps) {
        double testVal = Double.NaN;
        double refVal = Double.NaN;
        Object ee = null;
        try {
            try {
                testVal = new Double(testValue);
                refVal = new Double(refValue);
                Assert.assertEquals((String)(message + " doubles "), (double)refVal, (double)testVal, (double)eps);
            }
            catch (NumberFormatException e) {
                Assert.assertEquals((String)(message + " String "), (Object)refValue, (Object)testValue);
            }
        }
        catch (ComparisonFailure e) {
            ee = e;
        }
        catch (AssertionError e) {
            ee = e;
        }
        if (ee != null) {
            throw new RuntimeException("[" + testValue + "] != [" + refValue + "]", (Throwable)ee);
        }
    }

    private static void compareAsDates(String message, String refValue, String testValue, double eps) {
        DateTime testVal = null;
        DateTime refVal = null;
        try {
            testVal = JodaDate.parseDate(testValue);
            refVal = JodaDate.parseDate(refValue);
        }
        catch (Exception e) {
            Assert.fail((String)("unequal strings " + testValue + " != " + refValue));
        }
    }

    private static void compareAsFloatArrays(String message, String refValue, String testValue, double eps) {
        Object ee = null;
        try {
            try {
                RealArray testArray = new RealArray(testValue);
                RealArray refArray = new RealArray(refValue);
                TestUtils.assertEquals(message, testArray, refArray, eps);
            }
            catch (NumberFormatException e) {
                Assert.assertEquals((String)(message + " String "), (Object)refValue, (Object)testValue);
            }
        }
        catch (ComparisonFailure e) {
            ee = e;
        }
        catch (AssertionError e) {
            ee = e;
        }
        if (ee != null) {
            throw new RuntimeException("[" + testValue + "] != [" + refValue + "]", (Throwable)ee);
        }
    }

    private static Element stripWhite(Element refNode) {
        refNode = new Element(refNode);
        XMLUtil.removeWhitespaceNodes(refNode);
        return refNode;
    }

    public static void alwaysFail(String message) {
        Assert.fail((String)("should always throw " + message));
    }

    public static String testEquals(String message, double[] a, double[] b, double eps) {
        String msg = TestUtils.testEquals(a, b, eps);
        return msg == null ? null : message + "; " + msg;
    }

    public static String testEquals(Real2 a, Real2 b, double eps) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (!Real.isEqual(a.x, b.x, eps) || !Real.isEqual(a.y, b.y, eps)) {
            s = "" + a + " != " + b;
        }
        return s;
    }

    public static void assertEquals(String message, double[] a, double[] b, double eps) {
        String s = TestUtils.testEquals(a, b, eps);
        if (s != null) {
            Assert.fail((String)(message + "; " + s));
        }
    }

    public static void assertEquals(String msg, double[] test, Plane3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 4", (long)4L, (long)test.length);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test, expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, Point3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 3", (long)3L, (long)test.length);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test, expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, Point3Vector expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)"must be of equal length ", (long)test.length, (long)expected.getArray().length);
        TestUtils.assertEquals(msg, test, expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, Real2 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 2", (long)2L, (long)test.length);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test, expected.getXY(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, Real2Vector expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)"must be of equal length ", (long)test.length, (long)expected.getXY().getArray().length);
        TestUtils.assertEquals(msg, test, expected.getXY().getArray(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, RealArray expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)"must be of equal length ", (long)test.length, (long)expected.getArray().length);
    }

    public static void assertEquals(String msg, double[] test, Transform2 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)("test should have 16 elements (" + msg + ")"), (long)9L, (long)test.length);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test, expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, Transform3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)("test should have 16 elements (" + msg + ")"), (long)16L, (long)test.length);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test, expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String msg, double[] test, Vector3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertEquals((String)"must be of length 3", (long)3L, (long)test.length);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test, expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, int rows, double[] test, RealSquareMatrix expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)("rows should be equal (" + msg + ")"), (long)rows, (long)expected.getRows());
        TestUtils.assertEquals(msg, test, expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String msg, int rows, int cols, double[] test, RealMatrix expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)("rows should be equal (" + msg + ")"), (long)rows, (long)expected.getRows());
        Assert.assertEquals((String)("columns should be equal (" + msg + ")"), (long)cols, (long)expected.getCols());
        TestUtils.assertEquals(msg, test, expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String msg, int rows, int cols, int[] test, IntMatrix expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)("rows should be equal (" + msg + ")"), (long)rows, (long)expected.getRows());
        Assert.assertEquals((String)("columns should be equal (" + msg + ")"), (long)cols, (long)expected.getCols());
        Assert.assertEquals((String)msg, (Object)test, (Object)expected.getMatrixAsArray());
    }

    public static void assertEquals(String message, int[] a, int[] b) {
        String s = TestUtils.testEquals(a, b);
        if (s != null) {
            Assert.fail((String)(message + "; " + s));
        }
    }

    public static void assertEquals(String msg, int[] test, IntArray expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)"must be of equal length ", (long)test.length, (long)expected.getArray().length);
        Assert.assertEquals((String)msg, (Object)test, (Object)expected.getArray());
    }

    public static void assertEquals(String msg, int[] test, IntSet expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)"must be of equal length ", (long)test.length, (long)expected.getElements().length);
        Assert.assertEquals((String)msg, (Object)test, (Object)expected.getElements());
    }

    public static void assertEquals(String msg, IntArray test, IntArray expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)msg, (Object)test.getArray(), (Object)expected.getArray());
    }

    public static void assertEquals(String msg, IntMatrix test, IntMatrix expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertNotNull((String)("expected should have columns (" + msg + ")"), (Object)expected.getCols());
        Assert.assertNotNull((String)("expected should have rows (" + msg + ")"), (Object)expected.getRows());
        Assert.assertNotNull((String)("test should have columns (" + msg + ")"), (Object)test.getCols());
        Assert.assertNotNull((String)("test should have rows (" + msg + ")"), (Object)test.getRows());
        Assert.assertEquals((String)("rows should be equal (" + msg + ")"), (long)test.getRows(), (long)expected.getRows());
        Assert.assertEquals((String)("columns should be equal (" + msg + ")"), (long)test.getCols(), (long)expected.getCols());
        Assert.assertEquals((String)msg, (Object)test.getMatrixAsArray(), (Object)expected.getMatrixAsArray());
    }

    public static void assertEquals(String msg, IntSet test, IntSet expected) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertEquals((String)msg, (Object)test.getElements(), (Object)expected.getElements());
    }

    public static void assertEquals(String msg, Line3 test, Line3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getPoint(), expected.getPoint(), epsilon);
        TestUtils.assertEquals(msg, test.getVector(), expected.getVector(), epsilon);
    }

    public static void assertEquals(String msg, Plane3 test, Plane3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getArray(), expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, Point3 test, Point3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("ref should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getArray(), expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, Point3 testPoint, Vector3 testVector, Line3 expected, double epsilon) {
        Assert.assertNotNull((String)("testPoint should not be null (" + msg + ")"), (Object)testPoint);
        Assert.assertNotNull((String)("testVector should not be null (" + msg + ")"), (Object)testVector);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, testPoint, expected.getPoint(), epsilon);
        TestUtils.assertEquals(msg, testVector, expected.getVector(), epsilon);
    }

    public static void assertEquals(String msg, Point3Vector test, Point3Vector expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getArray(), expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, Real2 test, Real2 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getXY(), expected.getXY(), epsilon);
    }

    public static void assertEquals(String msg, Real2Vector expected, Real2Vector test, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, expected.getXY().getArray(), test.getXY().getArray(), epsilon);
    }

    public static void assertEquals(String msg, Real3Range r3ref, Real3Range r3, double epsilon) {
        TestUtils.assertEquals("xRange", r3.getXRange(), r3ref.getXRange(), epsilon);
        TestUtils.assertEquals("yRange", r3.getYRange(), r3ref.getYRange(), epsilon);
        TestUtils.assertEquals("zRange", r3.getZRange(), r3ref.getZRange(), epsilon);
    }

    public static void assertEquals(String msg, RealArray test, RealArray expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getArray(), expected.getArray(), epsilon);
    }

    public static void assertEquals(String msg, RealMatrix test, RealMatrix expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertNotNull((String)("expected should have columns (" + msg + ")"), (Object)expected.getCols());
        Assert.assertNotNull((String)("expected should have rows (" + msg + ")"), (Object)expected.getRows());
        Assert.assertNotNull((String)("test should have columns (" + msg + ")"), (Object)test.getCols());
        Assert.assertNotNull((String)("test should have rows (" + msg + ")"), (Object)test.getRows());
        Assert.assertEquals((String)("rows should be equal (" + msg + ")"), (long)test.getRows(), (long)expected.getRows());
        Assert.assertEquals((String)("columns should be equal (" + msg + ")"), (long)test.getCols(), (long)expected.getCols());
        TestUtils.assertEquals(msg, test.getMatrixAsArray(), expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String msg, RealRange ref, RealRange r, double epsilon) {
        Assert.assertEquals((String)(msg + " min"), (double)r.getMin(), (double)ref.getMin(), (double)epsilon);
        Assert.assertEquals((String)(msg + " max"), (double)r.getMax(), (double)ref.getMax(), (double)epsilon);
    }

    public static void assertEquals(String msg, RealSquareMatrix test, RealSquareMatrix expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        Assert.assertNotNull((String)("expected should have columns (" + msg + ")"), (Object)expected.getCols());
        Assert.assertNotNull((String)("expected should have rows (" + msg + ")"), (Object)expected.getRows());
        Assert.assertNotNull((String)("test should have columns (" + msg + ")"), (Object)test.getCols());
        Assert.assertNotNull((String)("test should have rows (" + msg + ")"), (Object)test.getRows());
        Assert.assertEquals((String)("rows should be equal (" + msg + ")"), (long)test.getRows(), (long)expected.getRows());
        Assert.assertEquals((String)("columns should be equal (" + msg + ")"), (long)test.getCols(), (long)expected.getCols());
        TestUtils.assertEquals(msg, test.getMatrixAsArray(), expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String message, String a, String[] b) {
        String[] aa = a.split(" ");
        String s = TestUtils.testEquals(aa, b);
        if (s != null) {
            Assert.fail((String)(message + "; " + s));
        }
    }

    public static void assertEquals(String message, String[] a, String[] b) {
        String s = TestUtils.testEquals(a, b);
        if (s != null) {
            Assert.fail((String)(message + "; " + s + "(" + Util.concatenate(a, "~") + " != " + Util.concatenate(b, "~")));
        }
    }

    public static void assertEquals(String msg, Transform2 test, Transform2 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getMatrixAsArray(), expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String msg, Transform3 test, Transform3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getMatrixAsArray(), expected.getMatrixAsArray(), epsilon);
    }

    public static void assertEquals(String msg, Vector2 test, Vector2 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getXY(), expected.getXY(), epsilon);
    }

    public static void assertEquals(String msg, Vector3 test, Vector3 expected, double epsilon) {
        Assert.assertNotNull((String)("test should not be null (" + msg + ")"), (Object)test);
        Assert.assertNotNull((String)("expected should not be null (" + msg + ")"), (Object)expected);
        TestUtils.assertEquals(msg, test.getArray(), expected.getArray(), epsilon);
    }

    public static void assertEqualsCanonically(String message, Element refNode, Element testNode, boolean stripWhite) {
        TestUtils.assertEqualsCanonically(message, refNode, testNode, stripWhite, true);
    }

    public static void assertEqualsCanonically(String message, String refXMLString, Element testNode, boolean stripWhite) {
        TestUtils.assertEqualsCanonically(message, TestUtils.parseValidString(refXMLString), testNode, stripWhite, true);
    }

    private static void assertEqualsCanonically(String message, Element refNode, Element testNode, boolean stripWhite, boolean reportError) throws Error {
        if (stripWhite) {
            refNode = TestUtils.stripWhite(refNode);
            testNode = TestUtils.stripWhite(testNode);
        }
        Throwable ee = null;
        try {
            XOMTestCase.assertEquals((String)message, (Element)refNode, (Element)testNode);
        }
        catch (ComparisonFailure e) {
            ee = e;
        }
        catch (AssertionFailedError e) {
            ee = e;
        }
        if (ee != null) {
            if (reportError) {
                TestUtils.reportXMLDiffInFull(message, ee.getMessage(), (Node)refNode, (Node)testNode);
            } else {
                throw ee;
            }
        }
    }

    public static void assertEqualsIncludingFloat(String message, Node refNode, Node testNode, boolean stripWhite, double eps, boolean report) {
        block3: {
            if (stripWhite && refNode instanceof Element && testNode instanceof Element) {
                refNode = TestUtils.stripWhite((Element)refNode);
                testNode = TestUtils.stripWhite((Element)testNode);
            }
            try {
                TestUtils.assertEqualsIncludingFloat(message, refNode, testNode, eps);
            }
            catch (RuntimeException e) {
                if (!report) break block3;
                TestUtils.reportXMLDiffInFull(message, e.getMessage(), refNode, testNode);
            }
        }
    }

    public static void assertNotEquals(String message, double[] a, double[] b, double eps) {
        String s = TestUtils.testEquals(a, b, eps);
        if (s == null) {
            Assert.fail((String)(message + "; arrays are equal"));
        }
    }

    public static void assertNotEquals(String message, int[] a, int[] b) {
        String s = TestUtils.testEquals(a, b);
        if (s == null) {
            Assert.fail((String)(message + "; arrays are equal"));
        }
    }

    public static void assertNotEquals(String message, String[] a, String[] b) {
        String s = TestUtils.testEquals(a, b);
        if (s == null) {
            Assert.fail((String)(message + "; arrays are equal"));
        }
    }

    public static void assertNotEqualsCanonically(String message, Node node1, Node node2) {
        try {
            Assert.assertEquals((String)message, (Object)node1, (Object)node2);
            String s1 = XMLUtil.getCanonicalString(node1);
            String s2 = XMLUtil.getCanonicalString(node2);
            Assert.fail((String)(message + "nodes should be different " + s1 + " != " + s2));
        }
        catch (ComparisonFailure comparisonFailure) {
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public static void assertObjectivelyEquals(String message, double[] a, double[] b, double eps) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + "/" + b.length;
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (Double.valueOf(a[i]).equals(b[i]) || !Real.isEqual(a[i], b[i], eps)) continue;
                s = "unequal element at (" + i + "), " + a[i] + " != " + b[i];
                break;
            }
        }
        if (s != null) {
            Assert.fail((String)(message + "; " + s));
        }
    }

    public static void assertWriteHTML(STMLElement element, String expected) {
        StringWriter sw = new StringWriter();
        try {
            element.writeHTML(sw);
            sw.close();
        }
        catch (IOException e) {
            Assert.fail((String)("should not throw " + e));
        }
        String s = sw.toString();
        Assert.assertEquals((String)"HTML output ", (Object)expected, (Object)s);
    }

    public static String getAssertFormat(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    public static void neverFail(Exception e) {
        Assert.fail((String)("should never throw " + e));
    }

    public static void neverThrow(Exception e) {
        throw new EuclidRuntimeException("should never throw " + e);
    }

    public static Element parseValidFile(String filename) {
        Element root = null;
        try {
            URL url = Util.getResource(filename);
            root = new Builder().build(new File(url.toURI())).getRootElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    public static Element parseValidFile(File file) {
        Element root = null;
        try {
            root = new Builder().build((InputStream)new FileInputStream(file)).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException("BUG ", e);
        }
        return root;
    }

    public static Element parseValidString(String s) {
        Element element = null;
        if (s == null) {
            throw new RuntimeException("NULL VALID JAVA_STRING");
        }
        try {
            element = XMLUtil.parseXML(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ERROR " + e + e.getMessage() + "..." + s.substring(0, Math.min(100, s.length())));
            Util.BUG(e);
        }
        return element;
    }

    protected static void reportXMLDiff(String message, String errorMessage, Node refNode, Node testNode) {
        Assert.fail((String)(message + " ~ " + errorMessage));
    }

    protected static void reportXMLDiffInFull(String message, String errorMessage, Node refNode, Node testNode) {
        try {
            System.err.println("Error: " + errorMessage);
            System.err.println("==========XMLDIFF reference=========");
            XMLUtil.debug((Element)refNode, System.err, 2);
            System.err.println("------------test---------------------");
            String s = testNode.toXML().replace("><", ">\n<");
            System.err.println(s);
            System.err.println("==============" + message + "===================");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.fail((String)(message + " ~ " + errorMessage));
    }

    static String testEquals(double[] a, double[] b, double eps) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + "/" + b.length;
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (Real.isEqual(a[i], b[i], eps)) continue;
                s = "unequal element at (" + i + "), " + a[i] + " != " + b[i];
                break;
            }
        }
        return s;
    }

    static String testEquals(double[][] a, double[][] b, double eps) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + "/" + b.length;
        } else {
            block0: for (int i = 0; i < a.length; ++i) {
                if (a[i].length != b[i].length) {
                    s = "row (" + i + ") has unequal lengths: " + a[i].length + "/" + b[i].length;
                    break;
                }
                for (int j = 0; j < a[i].length; ++j) {
                    if (Real.isEqual(a[i][j], b[i][j], eps)) continue;
                    s = "unequal element at (" + i + ", " + j + "), (" + a[i][j] + " != " + b[i][j] + ")";
                    continue block0;
                }
            }
        }
        return s;
    }

    public static String testEquals(int[] a, int[] b) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + "/" + b.length;
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                s = "unequal element (" + i + "), " + a[i] + " != " + b[i];
                break;
            }
        }
        return s;
    }

    public static String testEquals(String[] a, String[] b) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + "/" + b.length;
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == null && b[i] == null || a[i] != null && b[i] != null && a[i].equals(b[i])) continue;
                s = "unequal element (" + i + "), expected: " + a[i] + " found: " + b[i];
                break;
            }
        }
        return s;
    }
}

