/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openscience.cdk.hash.EquivalentSetFinder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.ringsearch.RingSearch;

final class AllEquivalentCyclicSet
extends EquivalentSetFinder {
    AllEquivalentCyclicSet() {
    }

    @Override
    Set<Integer> find(long[] invariants, IAtomContainer container, int[][] graph) {
        int n = invariants.length;
        RingSearch ringSearch = new RingSearch(container, graph);
        TreeMap<Long, HashSet<Integer>> equivalent = new TreeMap<Long, HashSet<Integer>>();
        for (int i = 0; i < invariants.length; ++i) {
            Long invariant = invariants[i];
            HashSet<Integer> set = (HashSet<Integer>)equivalent.get(invariant);
            if (set == null) {
                if (!ringSearch.cyclic(i)) continue;
                set = new HashSet<Integer>(n / 2);
                set.add(i);
                equivalent.put(invariant, set);
                continue;
            }
            set.add(i);
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (Map.Entry e : equivalent.entrySet()) {
            Set vertices = (Set)e.getValue();
            if (vertices.size() <= 1) continue;
            set.addAll(vertices);
        }
        return set;
    }
}

