% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcensI.R
\name{rcensI}
\alias{rcensI}
\title{Generate interval censoring sample}
\usage{
rcensI(
  rdistrX,
  rdistrC,
  param_X,
  param_C,
  n = 10000,
  epsilon = 0.5,
  n_mc = 10000,
  theta = 1,
  verbose = FALSE
)
}
\arguments{
\item{rdistrX}{sample generator of distribution X. \cr
First argument number of samples, next arguments in param_X.}

\item{rdistrC}{sample generator of distribution C. \cr First argument number of samples, next arguments in param_C.}

\item{param_X}{list with parameters of rdistrX function.}

\item{param_C}{list with parameters of rdistrC function, one of these parameters \cr should be "lambda",
this wil be the searched parameter.}

\item{n}{number of sample to create.}

\item{epsilon}{Parameter to estimate the number of visit (in [0,1]), shrink it only if the algorithm takes too long}

\item{n_mc}{number of sample use to estimate the moments of C, greater n_mc more accuracy.}

\item{theta}{Desired censoring percentage}

\item{verbose}{if TRUE print a censoring percentage of new created database.}
}
\value{
A list with sample data information: \tabular{ll}{
   \code{sample_censored} \tab vector of censored sample \cr
   \tab \cr
   \code{sample_uncensored} \tab vector of uncensored sample (original) \cr
   \tab \cr
   \code{censored_indicator} \tab vector of 1 and 0 indicating whether the i-th sample is censored  \cr
   \tab 1:= no censored, 0:= censored \cr
   \code{n_censored} \tab number of censored samples  \cr
}
}
\description{
Generator of interval censored samples where the length of interval is random,
 given a generator of samples of the distribution X (rdistrX) with
 parameters appended by the list param_X. Generator sample
 of distribution C (censoring) with parameters appended by the list param_C
 In which, you can control the desired censorship percentage.
}
\examples{
#Example Exponential - Uniform

Data_I = rcensI(rdistrX = rexp, rdistrC = runif,
               param_X = list("rate" = 2),
              param_C = list("min" = 0, "max" = 1),
             n = 1e02, theta = .9)

## Example with plot in examples_plot/Example_rcensI_plot.R
}
\seealso{
\code{\link{rcensT1}} for generate censorship sample type I.\cr
\code{\link{rcensT2}} for generate censorship sample type II.\cr
\code{\link{rcensT3}} for generate censorship sample type III\cr
\code{\link{rcensIfix}} for generate interval censoring sample
 with fix length interval
}
\author{
Daniel Saavedra Morales
}
