% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMCMRTable.r
\name{PMCMRTable}
\alias{PMCMRTable}
\title{Convert PMCMR Objects to a Data Frame}
\usage{
PMCMRTable(PMCMR, reverse = TRUE, digits = 3)
}
\arguments{
\item{PMCMR}{A PMCMR object}

\item{reverse}{If \code{TRUE}, reports the comparison as e.g. (B - A = 0).
This will more closely match the output of 
\code{PMCMRplus::summary.PMCMR} for all-pairs comparisons.
If \code{FALSE}, reports the comparison as e.g. (A - B = 0).
This will result in the output from \code{rcompanion::cldList}
matching the output of
\code{PMCMRplus::summaryGroup}}

\item{digits}{The significant digits in the output}
}
\value{
A data frame of comparisons and p-values
}
\description{
Extracts a data frame of comparisons and p-values
             from an PMCMR object from the PMCMRplus
             package
}
\details{
Should produce meaningful output for all-pairs 
         and many-to-one comparisons.
}
\references{
\url{https://rcompanion.org/handbook/F_08.html}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
