% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcssci_quasipoisson.R
\name{rcssci_quasipoisson}
\alias{rcssci_quasipoisson}
\title{rcssci_quasipoisson}
\arguments{
\item{data}{data.frame.Rdata}

\item{knot}{knot=3-7 or automatic calculate by AIC min}

\item{y}{outcome=0,1}

\item{covs}{covariables, univariate analysis  without "covs" command, multivariable analysis  with "covs" command}

\item{prob}{position parameter,range from 0-1}

\item{x}{main exposure and X-axis when plotting}

\item{filepath}{path of plots output.}
}
\value{
message.print PH assumption and other message
}
\description{
restricted cubic splines (RCS) published in SCI.
}
\details{
quasipoisson models with RCS splines were performed to explore the shape linear or nonlinear(U, inverted U,J,S,L,log,-log,temporary plateau shape)
}
\examples{
\donttest{library(rcssci)
rcssci_quasipoisson(data=sbpdata, y = "status",x = "sbp",
prob=0.1,filepath=tempdir())}
# library(rcssci)
# rcssci_quasipoisson(knot=4,data=sbpdata, y = "status",x = "sbp",
# covs=c("age","gender"),prob=0.1,filepath="D:/temp")

}
\author{
Zhiqiang Nie, \email{niezhiqiang@gdph.org.cn}
}
