% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_test.R
\name{dc_test}
\alias{dc_test}
\title{McCrary Sorting Test}
\usage{
dc_test(
  runvar,
  cutpoint,
  bin = NULL,
  bw = NULL,
  verbose = TRUE,
  plot = TRUE,
  ext.out = FALSE,
  htest = FALSE,
  level = 0.95,
  digits = max(3, getOption("digits") - 3),
  timeout = 30
)
}
\arguments{
\item{runvar}{A numeric vector containing the running variable.}

\item{cutpoint}{A numeric value containing the cutpoint at which assignment to the treatment is determined. The default is 0.}

\item{bin}{A numeric value containing the binwidth. The default is \code{2*sd(runvar)*length(runvar)^(-.5)}.}

\item{bw}{A numeric value containing bandwidth to use. If no bandwidth is supplied, the default uses bandwidth selection calculation 
from McCrary (2008).}

\item{verbose}{A logical value indicating whether to print diagnostic information to 
the terminal. The default is \code{TRUE}.}

\item{plot}{A logical value indicating whether to plot the histogram and density estimations 
The default is \code{TRUE}. The user may wrap this function in additional graphical options 
to modify the plot.}

\item{ext.out}{A logical value indicating whether to return extended output. 
The default is \code{FALSE}. When \code{FALSE} \code{dc_test} will return only the p-value of the test, but will print more information. 
When \code{TRUE}, \code{dc_test} will return and print the additional information documented below.}

\item{htest}{A logical value indicating whether to return an \code{"htest"} object 
compatible with base R's hypothesis test output. The default is \code{FALSE}.}

\item{level}{A numerical value between 0 and 1 specifying the confidence level for confidence intervals. The default is 0.95.}

\item{digits}{A non-negative integer specifying the number of digits to display in all output.
The default is \code{max(3, getOption("digits") - 3)}.}

\item{timeout}{A non-negative numerical value specifying the maximum number of seconds that 
expressions in the function are allowed to run. The default is 30. Specify \code{Inf} to run all expressions
to completion.}
}
\value{
If \code{ext.out} is \code{FALSE}, \code{dc_test} returns a numeric value specifying the p-value of the McCrary (2008) sorting test. 
  Additional output is enabled when \code{ext.out} is \code{TRUE}. 
  In this case, \code{dc_test} returns a list with the following elements:
\item{theta}{The estimated log difference in heights of the density curve at the cutpoint.}
\item{se}{The standard error of \code{theta}.}
\item{z}{The z statistic of the test.}
\item{p}{The p-value of the test. A p-value below the significance threshold indicates 
  that the user can reject the null hypothesis of no sorting.}
\item{binsize}{The calculated size of bins for the test.}
\item{bw}{The calculated bandwidth for the test.}
\item{cutpoint}{The cutpoint used.}
\item{data}{A dataframe for the binning of the histogram. Columns are \code{cellmp} 
  (the midpoints of each cell) and \code{cellval} (the normalized height of each cell).}
}
\description{
\code{dc_test} implements the McCrary (2008) sorting test to identify violations of assignment rules.
It is based on the \code{DCdensity} function in the "rdd" package.
}
\examples{
set.seed(12345)
# No discontinuity
x <- runif(1000, -1, 1)
dc_test(x, 0)

# Discontinuity
x <- runif(1000, -1, 1)
x <- x + 2 * (runif(1000, -1, 1) > 0 & x < 0)
dc_test(x, 0)
}
\references{
McCrary, J. (2008).
  Manipulation of the running variable in the regression discontinuity design: A density test. 
  Journal of Econometrics, 142(2), 698-714. 
  \doi{10.1016/j.jeconom.2007.05.005}.

Drew Dimmery (2016). rdd: Regression Discontinuity Estimation. R package version 0.57. https://CRAN.R-project.org/package=rdd
}
