% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/react.R
\docType{data}
\name{react}
\alias{react}
\title{Reactivity helper}
\format{
An object of class \code{react} of length 0.
}
\usage{
react
}
\description{
The \code{react} object gives alternative syntax to call
shiny reactive expressions.
}
\details{
The benefit is that it makes them easier to spot in your code.
}
\examples{
# This works by invoking the function from the parent environment
# with no arguments ...
foo <- function() {
  42
}
react$foo
react[foo]
react[foo()]

\dontrun{
  # ... but it only becomes relevant when used in shiny
  # server code, e.g. this app from the shiny page
  # with react$dataInput instead of dataInput()
  server <- function(input, output) {

    dataInput <- reactive({
      getSymbols(input$symb, src = "yahoo",
          from = input$dates[1],
            to = input$dates[2],
            auto.assign = FALSE)
    })

    output$plot <- renderPlot({
       chartSeries(react$dataInput, theme = chartTheme("white"),
              type = "line", log.scale = input$log, TA = NULL)
    })
  }
}
}
\keyword{datasets}
