% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bulk.R
\name{read_bulk}
\alias{read_bulk}
\title{Read and combine multiple data files}
\usage{
read_bulk(
  directory = ".",
  subdirectories = FALSE,
  name_contains = NULL,
  name_filter = NULL,
  extension = NULL,
  data = NULL,
  verbose = TRUE,
  fun = utils::read.csv,
  ...
)
}
\arguments{
\item{directory}{a character string. Name of the folder where the raw data
are stored. If it does not contain an absolute path, the file name is
relative to the current working directory. Defaults to current working
directory.}

\item{subdirectories}{logical indicating whether the directory contains
subdirectories. If \code{FALSE} (the default), it is assumed that all raw
data files are directly included in the directory. If \code{TRUE}, it is
assumed that the raw data files are stored in folders within the directory.
Alternatively, a vector of folder names that contain the raw data.}

\item{name_contains}{an optional character string. If specified, only files
whose name contains this string will be merged.}

\item{name_filter}{an optional regular expression. If specified, only files
whose name matches this regular expression will be merged.}

\item{extension}{an optional character string. If specified, only files
ending with the specified extension will be merged.}

\item{data}{A \code{data.frame} to which the new data will be added. This is
optional, and an empty \code{data.frame} is used if none is provided.}

\item{verbose}{logical indicating whether function should report its
progress.}

\item{fun}{the function used for reading the individual files. By default,
this is \link[utils:read.table]{read.csv}. Can be any data import function as long as it
takes the file name as first argument.}

\item{...}{additional arguments passed on to \code{fun}.}
}
\value{
A \link{data.frame} containing the merged data.

  One column in the data.frame (\code{File}) contains the name of the raw
  data file. If the \code{subdirectories} option is set, an additional column
  (\code{Subdirectory}) with the name of the subdirectory is added.
}
\description{
Read and combine multiple data files. The files will be merged into one
\link{data.frame}.
}
\details{
\code{read_bulk} provides a wrapper around a specific data import function
(\link[utils:read.table]{read.csv} by default) to load the individual data files. After
loading, the different data files are merged using \link[plyr]{rbind.fill}.
This function can deal with varying column names across files, and still
places data into the appropriate columns. If a column is not present in a
specific file, it will be filled with \code{NA}.
}
\examples{
\dontrun{
# Merge all files in the main folder "raw_data"
# (which is in the current working directory)
raw_data <- read_bulk(directory = "raw_data")

# Merge files with file extension ".csv"
raw_data <- read_bulk(directory = "raw_data",
  extension = ".csv")

# Merge all files stored in separate folders
# within the folder "raw_data"
raw_data <- read_bulk(directory = "raw_data",
  subdirectories = TRUE)

# Merge all raw data stored in the folders "Session1"
# and "Session2" within the folder "raw_data"
raw_data <- read_bulk(directory = "raw_data",
  subdirectories = c("Session1","Session2"))

# Merge tab separated data files and prevent
# character vectors from being converted to factors
raw_data <- read_bulk(directory = "raw_data",
  fun=read.delim,stringsAsFactors=FALSE)
}
}
\seealso{
\link{read.table} for reading individual data files.

  \link[plyr]{rbind.fill} is responsible for merging files.

  \link{write.table} for data export.
}
