% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact_inputs.R
\name{sd_impact_inputs}
\alias{sd_impact_inputs}
\title{Construct inputs for performing structural analysis via the impact method}
\usage{
sd_impact_inputs(desc_list)
}
\arguments{
\item{desc_list}{Element 'description' from the list returned by \code{read_xmile()}}
}
\value{
A list of three elements. The first element, \code{flows}, is a data
  frame that lists all the stock-flow links in the model. Further, this data
  frame describes the equation that governs the link and whether the link is
  an inflow (+) or an outflow (-). The second element, \code{pathways}, is a
  data frame that lists all the pathways among stocks. The third element,
  \code{velocities}, is a data frame in which each row corresponds to a
  stock. Each row consists of two columns (name  & equation).
}
\description{
Construct inputs for performing structural analysis via the impact method
}
\examples{
  filepath  <- system.file("models/", "SIR.stmx", package = "readsdr")
  mdl       <- read_xmile(filepath)
  desc_list <- mdl$description
  sd_impact_inputs(desc_list)
}
