% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator_measurements.R
\name{sd_measurements}
\alias{sd_measurements}
\title{Generate measurements}
\usage{
sd_measurements(
  n_meas,
  meas_model,
  ds_inputs,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler"
)
}
\arguments{
\item{n_meas}{Number of measurements. An integer.}

\item{meas_model}{Measurement model. A list of strings, in which each string
corresponds to sampling statement in Stan language.}

\item{ds_inputs}{A list of deSolve inputs generated by read_xmile}

\item{start_time}{A number indicating the time at which the simulation begins.}

\item{stop_time}{A number indicating the time at which the simulation ends.}

\item{timestep}{A number indicating the time interval for the simulation.
Also known as \code{dt}.}

\item{integ_method}{A string indicating the integration method. It can be
either "euler" or "rk4"}
}
\value{
A data frame.
}
\description{
Generate measurements
}
\examples{
  filepath <- system.file("models/", "SEIR.stmx", package = "readsdr")
  mdl      <- read_xmile(filepath)

  mm1        <- "y ~ poisson(C)"
  meas_model <- list(mm1)

  sd_measurements(n_meas       = 2,
                  meas_model   = meas_model,
                  ds_inputs    = mdl$deSolve_components,
                  start_time   = 0,
                  stop_time    = 10,
                  timestep     = 1/16,
                  integ_method = "rk4")
}
