% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/what_if_from_time.R
\name{sd_what_if_from_time}
\alias{sd_what_if_from_time}
\title{What if from time t we change the value of some parameters}
\usage{
sd_what_if_from_time(
  time,
  up_to_time = Inf,
  par_list,
  ds_inputs,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler"
)
}
\arguments{
\item{time}{Time at which the parameter values change}

\item{up_to_time}{Time from which the original values are restored.}

\item{par_list}{A list that indicates which parameters change from time t.
For instance, if you wanted to change the value of parameter \code{c} to 4,
you would provide the \code{list(c = 4)}}

\item{ds_inputs}{A list of deSolve inputs generated by read_xmile}

\item{start_time}{A number indicating the time at which the simulation begins.}

\item{stop_time}{A number indicating the time at which the simulation ends.}

\item{timestep}{A number indicating the time interval for the simulation.
Also known as \code{dt}.}

\item{integ_method}{A string indicating the integration method. It can be
either "euler" or "rk4"}
}
\value{
A data frame
}
\description{
What if from time t we change the value of some parameters
}
\examples{
  filepath       <- system.file("models/", "SIR.stmx", package = "readsdr")
  mdl            <- read_xmile(filepath)
  ds_components  <- mdl$deSolve_components
  output         <- sd_what_if_from_time(3, Inf, list(c = 4), ds_components)
}
