% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realTimeloads-package.R
\docType{package}
\name{realTimeloads-package}
\alias{realTimeloads}
\alias{realTimeloads-package}
\title{Tools For Computing Loads From Real-time Estimates of Concentration and Discharge with Code for Processing Acoustic Backscatter}
\description{
Code for computing loads from real-time estimates of concentration and discharge and processing of acoustic backscatter from acoustic Doppler velocimeters (ADVM) and acoustic Doppler current profilers (ADCP) per Livsey (in review)
}
\section{Functions}{


\code{\link{acoustic_backscatter_processing}} Process acoustic backscatter from horizontally profiling ADVM/ADCP

\code{\link{attenuation_of_sound_by_water}} Computes attenuation of sound in water for acoustic backscatter processing

\code{\link{bootstrap_regression}} Compute regression parameters with uncertainty from analyte(surrogate(s))

\code{\link{butterworth_tidal_filter}} Estimate non-tidal variabilty using butterworth filter of Rulh and Simpson (2005)

\code{\link{compute_load}} Compute analyte load from surrogate, regression, and discharge data

\code{\link{ctd2sal}} Convert conductance to salinity in PSU

\code{\link{estimate_timeseries}} Estimate timeseries with uncertainty using outputs from bootstrap_regression() and timeseries of surrogate(s)

\code{\link{ExampleCode}} Process acoustic backscatter from synthetic data detailed in Livsey et al (in review)

\code{\link{ExampleCodeSCI}} Compute load from synthetic data using "Sediment Composition Index" (SCI) after Livsey et al (2023)

\code{\link{hADCPLoads}} Process acoustic backscatter from user data and compute load using list generated by import_Data()

\code{\link{import_data}} Import data from files in user-specified folder for use in hADCPLoads()

\code{\link{impute_data}} impute non-tidal or tidal data using ARIMA and decision tree algorithms

\code{\link{linear_interpolation_with_time_limit}} Interpolate timeseries onto new timestep, Nan returned when nearest observation exceeds time limit specified

\code{\link{near_field_correction}} Compute near-field correction for acoustic backscatter processing

\code{\link{speed_of_sound}} Compute speed of sound in water for acoustic backscatter processing

\code{\link{surrogate_to_analyte_interpolation}} Pair surrogate timeseries t(x) to analyte sample times t(y)
}

\references{
Livsey, D.N. (in review). National Industry Guidelines for hydrometric monitoring–Part 12: Application of acoustic Doppler velocity meters to measure suspended-sediment load. Bureau of Meteorology. Melbourne, Australia.
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
\keyword{internal}
