% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdregionspecies.R
\name{ebirdregionspecies}
\alias{ebirdregionspecies}
\title{Get a list of species codes ever seen in a location.}
\usage{
ebirdregionspecies(location, key = NULL, ...)
}
\arguments{
\item{location}{Any valid location, USFWS region, subnational2, subnational1,
country, or custom region code. (Location can be a hotspot or personal location).}

\item{key}{eBird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an
environment variable called \code{EBIRD_KEY}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A single column data.frame containing the collected information:

"speciesCode": eBird species code, suitable for joining
   to the \code{\link[rebird]{ebirdtaxonomy}}
}
\description{
Returns the eBird codes for all species-level taxa recorded in a particular
region or location. Codes are returned in taxonomic order.
}
\examples{
\dontrun{
ebirdregionspecies("GB") # all in Great Britain
ebirdregionspecies("GB-ENG") # all in England
ebirdregionspecies("GB-ENG-LND") # all in London

library(dplyr)
taxonomy <- ebirdtaxonomy()
localSpecies <- ebirdregionspecies("L5803024") # specific hotspot
inner_join(localSpecies, taxonomy)
}
}
\references{
\url{http://ebird.org/}
}
\author{
David Bradnum \email{david.bradnum@gmail.com}
}
