% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{rec.avg.wb.domains}
\alias{rec.avg.wb.domains}
\title{REC Metric 2}
\usage{
rec.avg.wb.domains(data, domainlist = NULL, domainnames = NULL, na.rm = TRUE)
}
\arguments{
\item{data}{A data.frame or tibble  (required)}

\item{domainlist}{A list of character vectors or numeric vectors denoting the
columns for each domain (required)}

\item{domainnames}{A character vector supplying updated names to be attached to
output}

\item{na.rm}{logical (defaults to TRUE)}
}
\value{
A single numerical value
}
\description{
For each domain i, the average of the REC entries within domain vs. the
average of the REC entries when looking at correlations between indicators in
domain D=i with indicators in domains other than i (note that this does NOT
include correlations in domain j with other indicators in domain j; for a
given domain, it is basically the average of the REC entries within the domain
vs. the average of the REC entries for all of the other entries in the column
of that domain). We might call this the REC domain coherence for domain i
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
  # Use the SCWB data example
  mylist <- list(
    domain_goodrel = c("cwbcloserel", "cwbrespect", "cwbtrust", "cwbmutuality"),
    domain_prolead = c("cwbbeneficence", "cwbintegrity", "cwbcompetence", "cwbvision"),
    domain_healthyprac = c("cwbrelgrowth", "cwbfairness", "cwbsustenance", "cwbachieve"),
    domain_satcomm = c("cwbsatisf", "cwbvalue", "cwbbelonging", "cwbwelcome"),
    domain_strongmiss = c("cwbpurpose", "cwbcontrib", "cwbinterconn", "cwbsynergy")
  )
  rec.avg.wb.domains(SCWB, mylist)
}
