% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{ocv_read_annotorious}
\alias{ocv_read_annotorious}
\title{Extract the areas of interests of an image}
\usage{
ocv_read_annotorious(data, image)
}
\arguments{
\item{data}{an object as returned by \code{\link{read_annotorious}}}

\item{image}{an ocv image object}
}
\value{
a list of ocv images with the extracted areas of interest
}
\description{
Extract the areas of interests of an image
}
\examples{
\dontshow{
if(require(opencv) && require(magick))
\{
}
library(opencv)
library(magick)
data(openseadragon_areas)
\dontshow{
  url <- system.file(package = "recogito", "examples",
                     "Cat_and_dog_standoff_(3926784260).jpg")
  attr(openseadragon_areas, "src") <- url
}
url  <- attr(openseadragon_areas, "src")
img  <- ocv_read(url)

areas <- ocv_read_annotorious(data = openseadragon_areas, image = img)
areas[[1]]
areas[[2]]
img <- lapply(areas, FUN = function(x) image_read(ocv_bitmap(x)))
img <- do.call(c, img)
img <- image_append(img, stack = FALSE)
image_resize(img, "x200")
\dontshow{
\}
}
}
