% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotImageArray.R
\name{plotImageArray}
\alias{plotImageArray}
\title{Plot a 3D array as an RGB image}
\usage{
plotImageArray(rgb_array, main = "", ...)
}
\arguments{
\item{rgb_array}{A 3D array of RGB values. Preferably output from
\code{\link[png:readPNG]{png::readPNG()}}, \code{\link[jpeg:readJPEG]{jpeg::readJPEG()}},
\link{recoloredImage}, \link{constructImage}, or \link{raster_to_array}.}

\item{main}{Optional title for plot.}

\item{...}{Parameters passed to \link[graphics:plot.default]{graphics::plot}.}
}
\value{
No return value; plots image.
}
\description{
Does what it says on the tin. An extremely simple wrapper for
\code{\link[graphics:rasterImage]{graphics::rasterImage()}}, but maintains aspect ratio, removes
axes, and reduces margins for cleaner plotting.
}
\examples{
# make a 100x100 image of random colors
random_colors <- array(runif(100 * 100 * 3),
                       dim = c(100, 100, 3))
recolorize::plotImageArray(random_colors)

# we can also plot...a real image
corbetti <- system.file("extdata/corbetti.png",
                       package = "recolorize")
img <- png::readPNG(corbetti)
plotImageArray(img)
}
