% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecoSys.R
\name{output}
\alias{output}
\title{Exporting Factorization Matrices}
\arguments{
\item{r}{Object returned by \code{\link{Reco}()}.}

\item{out_P}{An object of class \code{Output} that specifies the
output format of the user matrix, typically returned by function
\code{\link{out_file}()}, \code{\link{out_memory}()} or
\code{\link{out_nothing}()}.
\code{\link{out_file}()} writes the matrix into a file, with
each row representing a user and each column representing a
latent factor.
\code{\link{out_memory}()} exports the matrix
into the return value of \code{$output()}.
\code{\link{out_nothing}()} means the matrix will not be exported.}

\item{out_Q}{Ditto, but for the item matrix.}
}
\value{
A list with components \code{P} and \code{Q}. They will be filled
        with user or item matrix if \code{\link{out_memory}()} is used
        in the function argument, otherwise \code{NULL} will be returned.
}
\description{
This method is a member function of class "\code{RecoSys}"
that exports the user score matrix \eqn{P} and the item score matrix \eqn{Q}.

Prior to calling this method, model needs to be trained using member function
\code{$\link{train}()}.

The common usage of this method is
\preformatted{r = Reco()
r$train(...)
r$output(out_P = out_file("mat_P.txt"), out_Q = out_file("mat_Q.txt"))}
}
\examples{
train_set = system.file("dat", "smalltrain.txt", package = "recosystem")
r = Reco()
set.seed(123) # This is a randomized algorithm
r$train(data_file(train_set), out_model = file.path(tempdir(), "model.txt"),
        opts = list(dim = 10, nmf = TRUE))

## Write P and Q matrices to files
P_file = out_file(tempfile())
Q_file = out_file(tempfile())
r$output(P_file, Q_file)
head(read.table(P_file@dest, header = FALSE, sep = " "))
head(read.table(Q_file@dest, header = FALSE, sep = " "))

## Skip P and only export Q
r$output(out_nothing(), Q_file)

## Return P and Q in memory
res = r$output(out_memory(), out_memory())
head(res$P)
head(res$Q)

}
\references{
W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A Fast Parallel Stochastic Gradient Method for Matrix Factorization in Shared Memory Systems.
ACM TIST, 2015.

W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A Learning-rate Schedule for Stochastic Gradient Methods to Matrix Factorization.
PAKDD, 2015.

W.-S. Chin, B.-W. Yuan, M.-Y. Yang, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
LIBMF: A Library for Parallel Matrix Factorization in Shared-memory Systems.
Technical report, 2015.
}
\seealso{
\code{$\link{train}()}, \code{$\link{predict}()}
}
\author{
Yixuan Qiu <\url{https://statr.me}>
}
