% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redbook_data.R
\docType{data}
\name{redbook_sp_data}
\alias{redbook_sp_data}
\title{Database of the Red Book of Endemic Plants of Peru}
\format{
A data frame with the following variables:

\describe{
\item{redbook_id}{Unique identifier for each species in the Red Book of Endemic Plants of Peru.}
\item{redbook_name}{Scientific name of the endemic species.}
\item{iucn}{Conservation category assigned according to IUCN.}
\item{publication}{Bibliographic reference where the taxon was originally described.}
\item{collector}{Name(s) of the collector(s) of the type specimen.}
\item{herbariums}{Acronyms of the institutions where the type specimens of the taxon are deposited.}
\item{common_name}{Common names of the species as mentioned in the literature.}
\item{dep_registry}{Abbreviations of the departments where the taxon has been recorded.}
\item{ecological_regions}{Abbreviations of the ecological regions proposed by Zamora (1996).}
\item{sinampe}{Abbreviation of the Protected Natural Area where the taxon was recorded.}
\item{peruvian_herbariums}{Acronyms of the Peruvian institutions where both type and non-type specimens are deposited.}
\item{remarks}{Observations and additional information about the endemic taxon.}
}
}
\usage{
redbook_sp_data
}
\description{
This database contains comprehensive information regarding the endemic plant species listed
in the Red Book of Endemic Plants of Peru. Each endemic taxon is accompanied by
corresponding variables that detail its taxonomic status, IUCN conservation category,
bibliographic references, type collection details, common names,
departmental registrations, ecological regions, protected natural areas (SINANPE),
and Peruvian herbaria where the specimens are deposited, as recorded in the original book.
}
\details{
This database provides essential information for research and conservation
efforts related to Peru's endemic flora, offering access to the data presented in the corresponding book.
}
\examples{

# Example illustrating how to load and explore the database
data("redbook_sp_data")
head(redbook_sp_data)

}
\references{
León, Blanca, et.al. 2006. “The Red Book of Endemic Plants of Peru”. Revista Peruana De Biología 13 (2): 9s-22s. https://revistasinvestigacion.unmsm.edu.pe/index.php/rpb/issue/view/153
}
\keyword{datasets}
