% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dist_euc}
\alias{dist_euc}
\title{Calculate Euclidean Distances}
\usage{
dist_euc(plans, ncores = 1)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{ncores}{Integer number of cores to use. Default is 1.}
}
\value{
matrix of plan distances
}
\description{
Calculate Euclidean Distances
}
\examples{
data(nh)
data(nh_m)
# For a single plan (distance is trivial, 0):
dist_euc(plans = nh$r_2020)

# Or many plans:
dist_euc(plans = nh_m[, 3:5])

}
\concept{distances}
