% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{splits_sub_total}
\alias{splits_sub_total}
\title{Count the Total Sub-Administrative Unit in Each Plan}
\usage{
splits_sub_total(plans, shp, sub_admin)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{sub_admin}{Unqouted name of column in shp with numeric identifiers for subsidiary administrative units.}
}
\value{
numeric matrix
}
\description{
Counts the total number of sub-administrative splits.
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
splits_sub_total(plans = nh$r_2020, shp = nh, sub_admin = county)

# Or many plans:
splits_sub_total(plans = nh_m[, 3:5], shp = nh, sub_admin = county)

}
\concept{splits}
