% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fosr2s.R
\name{fosr2s}
\alias{fosr2s}
\title{Two-step function-on-scalar regression}
\usage{
fosr2s(
  Y,
  X,
  argvals = seq(0, 1, , ncol(Y)),
  nbasis = 15,
  norder = 4,
  pen.order = norder - 2,
  basistype = "bspline"
)
}
\arguments{
\item{Y}{the functional responses, given as an \eqn{n\times d} matrix.}

\item{X}{\eqn{n\times p} model matrix, whose columns represent scalar
predictors. Should ordinarily include a column of 1s.}

\item{argvals}{the \eqn{d} argument values at which the functional
responses are evaluated, and at which the coefficient functions will be
evaluated.}

\item{nbasis}{number of basis functions used to represent the coefficient
functions.}

\item{norder}{norder of the spline basis, when \code{basistype="bspline"}
(the default, 4, gives cubic splines).}

\item{pen.order}{order of derivative penalty.}

\item{basistype}{type of basis used. The basis is created by an appropriate
constructor function from the \pkg{fda} package; see basisfd. Only \code{"bspline"} and \code{"fourier"} are
supported.}
}
\value{
An object of class \code{fosr}, which is a list with the following
elements: \item{fd}{object of class \code{"{fd}"} representing the
estimated coefficient functions. Its main components are a basis and a
matrix of coefficients with respect to that basis. }
\item{raw.coef}{\eqn{d\times p} matrix of coefficient estimates from
regressing on \code{X} separately at each point along the function. }
\item{raw.se}{\eqn{d\times p} matrix of standard errors of the raw
coefficient estimates. } \item{yhat}{\eqn{n\times d} matrix of fitted
values. } \item{est.func}{\eqn{d\times p} matrix of coefficient function
estimates, obtained by smoothing the columns of \code{raw.coef}. }
\item{se.func}{\eqn{d\times p} matrix of coefficient function standard
errors. } \item{argvals}{points at which the coefficient functions are
evaluated. } \item{lambda}{smoothing parameters (chosen by REML) used to
smooth the \eqn{p} coefficient functions with respect to the supplied
basis. }
}
\description{
This function performs linear regression with functional responses and
scalar predictors by (1) fitting a separate linear model at each point
along the function, and then (2) smoothing the resulting coefficients to
obtain coefficient functions.
}
\details{
Unlike \code{{fosr}} and \code{{pffr}}, which obtain smooth
coefficient functions by minimizing a penalized criterion, this function
introduces smoothing only as a second step. The idea was proposed by Fan
and Zhang (2000), who employed local polynomials rather than roughness
penalization for the smoothing step.
}
\references{
Fan, J., and Zhang, J.-T. (2000). Two-step estimation of
functional linear models with applications to longitudinal data.
\emph{Journal of the Royal Statistical Society, Series B}, 62(2), 303--322.
}
\seealso{
\code{{fosr}}, \code{{pffr}}
}
\author{
Philip Reiss \email{phil.reiss@nyumc.org} and Lan Huo
}
