% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{match_group}
\alias{match_group}
\title{Extract a Specific Named Group from a String}
\usage{
match_group(pattern, s, group_name, ignore.case = FALSE)
}
\arguments{
\item{pattern}{A character string containing the regex pattern with named groups.}

\item{s}{A character string where the pattern will be searched.}

\item{group_name}{The name of the group to extract from the match.}

\item{ignore.case}{Logical. If TRUE, the pattern matching is case-insensitive. Default is FALSE.}
}
\value{
The extracted value of the specified named group, or NULL if the group is not found.
}
\description{
This function extracts the value of a specific named group from a string using the provided regex pattern.
}
\examples{
pattern <- "(?P<name>\\\\w+) is (?P<age>\\\\d+)"
s <- "Jane is 25"
match_group(pattern, s, "name")
# [1] "Jane"

}
