% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{replace_group}
\alias{replace_group}
\title{Replace a Specific Named Group in a String}
\usage{
replace_group(pattern, s, group_name, replacer, ignore.case = FALSE)
}
\arguments{
\item{pattern}{A character string containing the regex pattern with named groups.}

\item{s}{A character string where the pattern will be searched.}

\item{group_name}{The name of the group to be replaced.}

\item{replacer}{A string that will replace the matched value of the specified group.}

\item{ignore.case}{Logical. If TRUE, the pattern matching is case-insensitive. Default is FALSE.}
}
\value{
A modified string where the matched value of the specified group has been replaced by the \code{replacer}.
}
\description{
This function replaces the value of a specific named group in a string using the provided regex pattern.
}
\examples{
pattern <- "(?P<name>\\\\w+) is (?P<age>\\\\d+)"
s <- "Jane is 25"
replace_group(pattern, s, "name", "John")
# [1] "John is 25"

}
