% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claims-class.R
\docType{methods}
\name{get_claims}
\alias{get_claims}
\alias{get_claims,Claims-method}
\title{Get claims}
\usage{
get_claims(object)

\S4method{get_claims}{Claims}(object)
}
\arguments{
\item{object}{The object to display}
}
\description{
\code{get_claims} gets the claims table of a \code{Claims} (\code{\link{Claims-class}}) object.
}
\examples{
c <- data.frame(year = unlist(sapply(2000:2017, function(x) rep(x, rpois(1,3)))))
c$amount <- pmax(rnorm(nrow(c), 200000, 100000), 0)
p <- aggregate(amount ~ year, c, sum)
claims <- claims(c, p)
get_claims(claims)

}
