% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_information.R
\name{get_changes}
\alias{get_changes}
\title{Extract changelog entries for a given version}
\usage{
get_changes(path, version_number, verbose = TRUE)
}
\arguments{
\item{path}{[\link[base]{character}] Path to the package root directory.}

\item{version_number}{[\link[base]{character}] Current version number string
(e.g. \code{"1.2.3"}).}

\item{verbose}{[\link[base]{logical}] Whether to print current and new
remote fields (default: \code{TRUE}).}
}
\value{
A character string containing the formatted changelog for the given
version.
}
\description{
Extracts the section of \code{NEWS.md} corresponding to a given version.
}
\examples{
path_rjd3workspace <- system.file("rjd3workspace", package = "releaser")

get_changes(path = path_rjd3workspace, version_number = "Unreleased")
get_changes(path = path_rjd3workspace, version_number = "3.2.4")
get_changes(path = path_rjd3workspace, version_number = "3.5.1")

}
