% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_information.R
\name{get_different_future_version}
\alias{get_different_future_version}
\title{Compute possible future semantic versions}
\usage{
get_different_future_version(version_number, verbose = TRUE)
}
\arguments{
\item{version_number}{[\link[base]{character}] Current version number string
(e.g. \code{"1.2.3"}).}

\item{verbose}{[\link[base]{logical}] Whether to print current and new
remote fields (default: \code{TRUE}).}
}
\value{
A named character vector with:
\itemize{
\item \code{current_version} – the input version,
\item \code{future_patch_version} – next patch version,
\item \code{future_minor_version} – next minor version,
\item \code{future_major_version} – next major version.
}
}
\description{
Given a current package version, compute the potential next
patch, minor, and major versions following semantic versioning rules.
}
\examples{
get_different_future_version("1.2.3")

}
