% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rgam.R
\name{plot.rgam}
\alias{plot.rgam}
\title{Make a plot of rgam model fit}
\usage{
\method{plot}{rgam}(x, newx, index, which = NULL, rugplot = TRUE,
  grid_length = 100, names, ...)
}
\arguments{
\item{x}{Fitted \code{rgam} object.}

\item{newx}{Matrix of values of each predictor at which to plot.}

\item{index}{Index of lambda value for which plotting is desired. Default is
the last lambda value in \code{x$lambda}.}

\item{which}{Which features to plot. Default is the first 4 or \code{nvars}
variables, whichever is smaller.}

\item{rugplot}{If \code{TRUE} (default), adds a rugplot showing the values of x
at the bottom of each fitted function plot.}

\item{grid_length}{The number of points to evaluate the estimated function at.
Default is 100.}

\item{names}{Vector of variable names of features in \code{which}. By default,
name of the \code{j}th variable is \code{xj}.}

\item{...}{Optional graphical parameters to plot.}
}
\description{
Produces plots of the estimated functions for specified variables at a given
value of lambda.
}
\details{
A plot of the specified fitted functions is produced. Nothing is returned.
}
\examples{
set.seed(1)
n <- 100; p <- 12
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 3), rep(0, 9)), ncol = 1)
y <- x \%*\% beta + x[, 4]^2 + rnorm(n)
fit <- rgam(x, y)

# default: print functions for first 4 variables
opar <- par(mfrow = c(2, 2))
plot(fit, newx = x, index = 20)
par(opar)

# print for variables 5 to 8
opar <- par(mfrow = c(2, 2))
plot(fit, newx = x, index = 20, which = 5:8)
par(opar)

}
